/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.personal;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.zutubi.pulse.core.PulseException;
import com.zutubi.pulse.core.model.CvsRevision;
import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.core.model.NumericalRevision;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.personal.PersonalBuildException;
import com.zutubi.pulse.personal.PersonalBuildUI;
import com.zutubi.pulse.scm.FileStatus;
import com.zutubi.pulse.scm.WorkingCopyStatus;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.NullOutputStream;
import com.zutubi.pulse.xstream.FileStatusConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class PatchArchive {
    private static final String META_ENTRY = "meta.xml";
    private File patchFile;
    private static final String FILES_PATH = "files/";
    private WorkingCopyStatus status;

    public PatchArchive(WorkingCopyStatus status, File patchFile, PersonalBuildUI ui) throws PersonalBuildException {
        this.patchFile = patchFile;
        this.status = status;
        try {
            this.createPatchArchive(status.getBase(), ui);
        }
        catch (IOException e) {
            throw new PersonalBuildException("I/O error creating patch file: " + e.getMessage(), e);
        }
    }

    public PatchArchive(File patchFile) throws PulseException {
        this.patchFile = patchFile;
        ZipInputStream zin = null;
        try {
            zin = new ZipInputStream(new FileInputStream(patchFile));
            ZipEntry entry = zin.getNextEntry();
            if (entry == null || !entry.getName().equals(META_ENTRY)) {
                throw new PulseException("Missing meta entry in patch file '" + patchFile.getAbsolutePath() + "'");
            }
            XStream xstream = this.createXStream();
            this.status = (WorkingCopyStatus)xstream.fromXML((InputStream)zin);
        }
        catch (IOException e) {
            try {
                throw new PulseException("I/O error reading status from patch file '" + patchFile.getAbsolutePath() + "': " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.close(zin);
                throw throwable;
            }
        }
        IOUtils.close(zin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPatchArchive(File base, PersonalBuildUI ui) throws IOException {
        ZipOutputStream os = null;
        try {
            os = new ZipOutputStream(new FileOutputStream(this.patchFile));
            this.addMeta(os, ui);
            this.addFiles(base, os, ui);
        }
        catch (Throwable throwable) {
            IOUtils.close(os);
            throw throwable;
        }
        IOUtils.close(os);
    }

    private void addMeta(ZipOutputStream os, PersonalBuildUI ui) throws IOException {
        this.status(ui, META_ENTRY);
        ZipEntry entry = new ZipEntry(META_ENTRY);
        os.putNextEntry(entry);
        XStream xstream = this.createXStream();
        xstream.toXML((Object)this.status, (OutputStream)os);
    }

    private XStream createXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.alias("status", WorkingCopyStatus.class);
        xstream.alias("revision", Revision.class);
        xstream.alias("numerical", NumericalRevision.class);
        xstream.alias("cvs", CvsRevision.class);
        xstream.omitField(Entity.class, "id");
        xstream.alias("fileStatus", FileStatus.class);
        xstream.addImplicitCollection(WorkingCopyStatus.class, "changes");
        xstream.setMode(1001);
        xstream.registerConverter((Converter)new FileStatusConverter());
        return xstream;
    }

    private void addFiles(File base, ZipOutputStream os, PersonalBuildUI ui) throws IOException {
        os.putNextEntry(new ZipEntry(FILES_PATH));
        for (FileStatus fs : this.status) {
            if (!fs.getState().requiresFile() || fs.isDirectory()) continue;
            File f = new File(base, FileSystemUtils.denormaliseSeparators(fs.getPath()));
            String path = FILES_PATH + fs.getTargetPath();
            this.addFile(os, f, path, ui);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(ZipOutputStream os, File f, String path, PersonalBuildUI ui) throws IOException {
        this.status(ui, path);
        ZipEntry entry = new ZipEntry(path);
        entry.setTime(f.lastModified());
        os.putNextEntry(entry);
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            IOUtils.joinStreams(is, os);
        }
        catch (Throwable throwable) {
            IOUtils.close(is);
            throw throwable;
        }
        IOUtils.close(is);
    }

    public File getPatchFile() {
        return this.patchFile;
    }

    public WorkingCopyStatus getStatus() {
        return this.status;
    }

    public void apply(File base, FileStatus.EOLStyle localEOL) throws PulseException {
        try {
            for (FileStatus fs : this.status) {
                fs.preApply(base);
            }
            this.unzip(base);
            for (FileStatus fs : this.status) {
                fs.postApply(base, localEOL);
            }
        }
        catch (IOException e) {
            throw new PulseException("I/O error applying patch file '" + this.patchFile.getAbsolutePath() + "': " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzip(File base) throws IOException {
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(new FileInputStream(this.patchFile));
            zin.getNextEntry();
            IOUtils.joinStreams(zin, new NullOutputStream());
            while ((entry = zin.getNextEntry()) != null) {
                this.extractEntry(base, entry, zin);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(zin);
            throw throwable;
        }
        IOUtils.close(zin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractEntry(File base, ZipEntry entry, ZipInputStream zin) throws IOException {
        String path = this.getPath(entry);
        File f = new File(base, path);
        if (entry.isDirectory()) {
            f.mkdirs();
            return;
        }
        File parent = f.getParentFile();
        if (parent != null && !parent.isDirectory()) {
            parent.mkdirs();
        }
        if (!f.canWrite()) {
            FileSystemUtils.setWritable(f);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            IOUtils.joinStreams(zin, out);
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
    }

    private String getPath(ZipEntry entry) throws IOException {
        String name = entry.getName();
        if (!name.startsWith(FILES_PATH)) {
            throw new IOException("Unexpected entry path '" + name + "': should start with '" + FILES_PATH + "'");
        }
        return name.substring(FILES_PATH.length());
    }

    public boolean containsPath(String path) {
        for (FileStatus fs : this.status) {
            if (!fs.getPath().equals(path) || !fs.getState().requiresFile()) continue;
            return true;
        }
        return false;
    }

    public String retrieveFile(String path) throws IOException {
        String string;
        path = FILES_PATH + path;
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(new FileInputStream(this.patchFile));
            while ((entry = zin.getNextEntry()) != null) {
                if (!entry.getName().equals(path)) continue;
                string = IOUtils.inputStreamToString(zin);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(zin);
            throw throwable;
        }
        {
            IOUtils.close(zin);
            return string;
        }
        throw new IOException("Path '" + path + "' not found in archive");
    }

    private void status(PersonalBuildUI ui, String message) {
        if (ui != null) {
            ui.status(message);
        }
    }
}

