/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.logging;

import com.zutubi.pulse.logging.HandlerFactory;
import com.zutubi.pulse.logging.LogUtils;
import com.zutubi.pulse.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogManager {
    private Map<String, HandlerFactory> handlerFactories = new HashMap<String, HandlerFactory>();

    public void setFactories(Map<String, HandlerFactory> factories) {
        this.handlerFactories = factories;
    }

    public void reset() {
        java.util.logging.LogManager.getLogManager().reset();
    }

    public void resetLevels() {
        Enumeration<String> loggerNames = java.util.logging.LogManager.getLogManager().getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            String loggerName = loggerNames.nextElement();
            Logger l = java.util.logging.LogManager.getLogManager().getLogger(loggerName);
            l.setLevel(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(File config) {
        if (!config.isFile()) {
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(config);
            Properties props = new Properties();
            props.load(fis);
            this.configure(props);
        }
        catch (IOException ioe) {
            try {
                ioe.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.close(fis);
                throw throwable;
            }
            IOUtils.close(fis);
        }
        IOUtils.close(fis);
    }

    public void configure(Properties config) {
        List<String> configNames = LogUtils.getList(config, "config", new LinkedList<String>());
        for (String configName : configNames) {
            try {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(configName);
                clz.newInstance();
            }
            catch (Exception ex) {
                System.err.println("Can't load config class \"" + configName + "\"");
                System.err.println("" + ex);
            }
        }
        List<String> handlerNames = LogUtils.getList(config, "handlers", new LinkedList<String>());
        HashMap<String, Handler> handlers = new HashMap<String, Handler>();
        for (String handlerName : handlerNames) {
            String type;
            Handler handler;
            if (!config.containsKey(handlerName + ".type") || (handler = this.createHandler(type = config.getProperty(handlerName + ".type"), handlerName, config)) == null) continue;
            handlers.put(handlerName, handler);
        }
        Enumeration<?> propertyNames = config.propertyNames();
        while (propertyNames.hasMoreElements()) {
            Logger l;
            String name;
            String propertyName = (String)propertyNames.nextElement();
            if (propertyName.compareTo("handlers") == 0) continue;
            if (propertyName.endsWith(".level")) {
                name = propertyName.substring(0, propertyName.length() - 6);
                l = Logger.getLogger(name);
                l.setLevel(LogUtils.getLevel(config, propertyName, null));
                continue;
            }
            if (!propertyName.endsWith(".handler")) continue;
            name = propertyName.substring(0, propertyName.length() - 8);
            l = Logger.getLogger(name);
            List<String> names = LogUtils.getList(config, propertyName, Collections.EMPTY_LIST);
            for (String n : names) {
                Handler h = (Handler)handlers.get(n);
                if (h == null) continue;
                l.addHandler(h);
            }
        }
    }

    private Handler createHandler(String type, String handlerName, Properties config) {
        if (this.handlerFactories.containsKey(type)) {
            HandlerFactory handlerFactory = this.handlerFactories.get(type);
            return handlerFactory.createHandler(handlerName, config);
        }
        try {
            Class<?> cls = Class.forName(type);
            return (Handler)cls.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }
}

