/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.model.TestCaseResult;
import com.zutubi.pulse.core.model.TestResult;
import com.zutubi.pulse.core.model.TestResultComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuiteResult
extends TestResult {
    private List<TestSuiteResult> suites;
    private LinkedHashMap<String, TestCaseResult> cases;
    private TestResultComparator comparator = new TestResultComparator();
    private int total;
    private int errors;
    private int failures;

    public TestSuiteResult() {
        this(null, -1L);
    }

    public TestSuiteResult(String name) {
        this(name, -1L);
    }

    public TestSuiteResult(String name, long duration) {
        this(name, duration, -1, -1, -1);
        this.suites = new ArrayList<TestSuiteResult>();
        this.cases = new LinkedHashMap();
    }

    public TestSuiteResult(String name, long duration, int total, int errors, int failures) {
        super(name, duration);
        this.total = total;
        this.errors = errors;
        this.failures = failures;
    }

    public void add(TestSuiteResult suite) {
        int index = Collections.binarySearch(this.suites, suite, this.comparator);
        if (index < 0) {
            this.suites.add(-index - 1, suite);
        } else {
            TestSuiteResult existing = this.suites.get(index);
            for (TestSuiteResult childSuite : suite.getSuites()) {
                existing.add(childSuite);
            }
            for (TestCaseResult childCase : suite.getCases()) {
                existing.add(childCase);
            }
        }
    }

    public void add(TestCaseResult childCase) {
        TestCaseResult existing = this.getCase(childCase.getName());
        if (existing == null) {
            this.cases.put(childCase.getName(), childCase);
        } else if (childCase.getStatus().compareTo(existing.getStatus()) > 0) {
            this.cases.put(childCase.getName(), childCase);
        }
    }

    public TestCaseResult getCase(String name) {
        return this.cases.get(name);
    }

    public boolean hasCase(String name) {
        return this.getCase(name) != null;
    }

    @Override
    public int getErrors() {
        if (this.errors < 0) {
            int result = 0;
            for (TestSuiteResult testSuiteResult : this.suites) {
                result += testSuiteResult.getErrors();
            }
            for (TestCaseResult testCaseResult : this.cases.values()) {
                result += testCaseResult.getErrors();
            }
            return result;
        }
        return this.errors;
    }

    @Override
    public int getFailures() {
        if (this.failures < 0) {
            int result = 0;
            for (TestSuiteResult testSuiteResult : this.suites) {
                result += testSuiteResult.getFailures();
            }
            for (TestCaseResult testCaseResult : this.cases.values()) {
                result += testCaseResult.getFailures();
            }
            return result;
        }
        return this.failures;
    }

    @Override
    public int getTotal() {
        if (this.total < 0) {
            int result = 0;
            for (TestSuiteResult testSuiteResult : this.suites) {
                result += testSuiteResult.getTotal();
            }
            for (TestCaseResult testCaseResult : this.cases.values()) {
                result += testCaseResult.getTotal();
            }
            return result;
        }
        return this.total;
    }

    @Override
    public boolean isSuite() {
        return true;
    }

    public List<TestSuiteResult> getSuites() {
        return this.suites;
    }

    public Collection<TestCaseResult> getCases() {
        return this.cases.values();
    }

    @Override
    public boolean isEquivalent(TestResult otherResult) {
        if (!(otherResult instanceof TestSuiteResult)) {
            return false;
        }
        TestSuiteResult other = (TestSuiteResult)otherResult;
        if (!super.isEquivalent(other)) {
            return false;
        }
        List<TestSuiteResult> otherSuites = other.getSuites();
        if (this.suites.size() != otherSuites.size()) {
            return false;
        }
        for (int i = 0; i < this.suites.size(); ++i) {
            if (this.suites.get(i).isEquivalent(otherSuites.get(i))) continue;
            return false;
        }
        Collection<TestCaseResult> otherCases = other.getCases();
        if (this.cases.size() != otherCases.size()) {
            return false;
        }
        Iterator<TestCaseResult> ourIt = this.cases.values().iterator();
        Iterator<TestCaseResult> otherIt = otherCases.iterator();
        while (ourIt.hasNext()) {
            if (ourIt.next().isEquivalent(otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public TestSuiteResult getSuite(String name) {
        for (TestSuiteResult suite : this.suites) {
            if (!suite.getName().equals(name)) continue;
            return suite;
        }
        return null;
    }
}

