/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.model.BuildingTestHandler;
import com.zutubi.pulse.core.model.TestCaseResult;
import com.zutubi.pulse.core.model.TestHandler;
import com.zutubi.pulse.core.model.TestSuiteResult;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.Text;

public class TestSuitePersister {
    private static final Logger LOG = Logger.getLogger(TestSuitePersister.class);
    public static final String SUITE_FILE_NAME = "suite.xml";
    public static final String ELEMENT_SUITE = "suite";
    public static final String ELEMENT_CASE = "case";
    public static final String ELEMENT_MESSAGE = "message";
    public static final String ATTRIBUTE_TOTAL = "total";
    public static final String ATTRIBUTE_FAILURES = "failures";
    public static final String ATTRIBUTE_ERRORS = "errors";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_DURATION = "duration";
    public static final String ATTRIBUTE_STATUS = "status";
    public static final String ATTRIBUTE_BROKEN_SINCE = "broken-since";
    public static final String ATTRIBUTE_BROKEN_NUMBER = "broken-number";
    public static final String ATTRIBUTE_FIXED = "fixed";

    public void write(TestSuiteResult suite, File directory) throws IOException {
        for (TestSuiteResult childSuite : suite.getSuites()) {
            File suiteDir = new File(directory, this.encodeName(childSuite.getName()));
            FileSystemUtils.createDirectory(suiteDir);
            this.write(childSuite, suiteDir);
        }
        this.writeCases(suite, new File(directory, SUITE_FILE_NAME));
    }

    private void writeCases(TestSuiteResult suite, File file) throws IOException {
        Document doc = this.suiteToDoc(suite);
        this.writeDocument(file, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocument(File file, Document doc) throws IOException {
        BufferedOutputStream bos = null;
        try {
            FileOutputStream fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            Serializer serializer = new Serializer((OutputStream)bos);
            serializer.write(doc);
        }
        catch (Throwable throwable) {
            IOUtils.close(bos);
            throw throwable;
        }
        IOUtils.close(bos);
    }

    private Document suiteToDoc(TestSuiteResult suite) {
        Element root = new Element(ELEMENT_SUITE);
        root.addAttribute(new Attribute(ATTRIBUTE_DURATION, Long.toString(suite.getDuration())));
        for (TestSuiteResult testSuiteResult : suite.getSuites()) {
            Element suiteElement = new Element(ELEMENT_SUITE);
            suiteElement.addAttribute(new Attribute(ATTRIBUTE_NAME, testSuiteResult.getName()));
            suiteElement.addAttribute(new Attribute(ATTRIBUTE_TOTAL, Integer.toString(testSuiteResult.getTotal())));
            suiteElement.addAttribute(new Attribute(ATTRIBUTE_FAILURES, Integer.toString(testSuiteResult.getFailures())));
            suiteElement.addAttribute(new Attribute(ATTRIBUTE_ERRORS, Integer.toString(testSuiteResult.getErrors())));
            suiteElement.addAttribute(new Attribute(ATTRIBUTE_DURATION, Long.toString(testSuiteResult.getDuration())));
            root.appendChild((Node)suiteElement);
        }
        for (TestCaseResult testCaseResult : suite.getCases()) {
            Element caseElement = new Element(ELEMENT_CASE);
            caseElement.addAttribute(new Attribute(ATTRIBUTE_NAME, testCaseResult.getName()));
            caseElement.addAttribute(new Attribute(ATTRIBUTE_DURATION, Long.toString(testCaseResult.getDuration())));
            caseElement.addAttribute(new Attribute(ATTRIBUTE_STATUS, testCaseResult.getStatusName()));
            String message = testCaseResult.getMessage();
            if (message != null) {
                Element messageElement = new Element(ELEMENT_MESSAGE);
                messageElement.appendChild(message);
                caseElement.appendChild((Node)messageElement);
            }
            root.appendChild((Node)caseElement);
        }
        return new Document(root);
    }

    public TestSuiteResult read(String name, File directory, boolean deep, boolean failuresOnly, int limit) throws IOException, ParsingException {
        BuildingTestHandler handler = new BuildingTestHandler();
        this.read(handler, name, directory, deep, failuresOnly, new Counter(limit));
        return handler.getTop();
    }

    public void read(TestHandler handler, String name, File directory, boolean deep, boolean failuresOnly) throws IOException, ParsingException {
        this.read(handler, name, directory, deep, failuresOnly, new Counter(0));
    }

    private void read(TestHandler handler, String name, File directory, boolean deep, boolean failuresOnly, Counter counter) throws IOException, ParsingException {
        File suiteFile = new File(directory, SUITE_FILE_NAME);
        Document doc = this.readDoc(suiteFile);
        long duration = this.getDuration(doc.getRootElement());
        handler.startSuite(new TestSuiteResult(name, duration));
        this.loadSuites(handler, doc, directory, deep, failuresOnly, counter);
        this.loadCases(handler, doc, failuresOnly, counter);
        if (handler.endSuite()) {
            this.writeDocument(suiteFile, doc);
        }
    }

    private void loadSuites(TestHandler handler, Document doc, File directory, boolean deep, boolean failuresOnly, Counter counter) throws IOException, ParsingException {
        Elements elements = doc.getRootElement().getChildElements(ELEMENT_SUITE);
        for (int i = 0; i < elements.size(); ++i) {
            Element element = elements.get(i);
            String name = element.getAttributeValue(ATTRIBUTE_NAME);
            long duration = this.getDuration(element);
            int total = this.getIntAttribute(element, ATTRIBUTE_TOTAL);
            int errors = this.getIntAttribute(element, ATTRIBUTE_ERRORS);
            int failures = this.getIntAttribute(element, ATTRIBUTE_FAILURES);
            if (name == null || failuresOnly && errors == 0 && failures == 0) continue;
            if (deep) {
                File child = new File(directory, this.encodeName(name));
                if (!child.isDirectory()) continue;
                this.read(handler, name, child, deep, failuresOnly, counter);
                if (!counter.isExhausted()) continue;
                return;
            }
            handler.startSuite(new TestSuiteResult(name, duration, total, errors, failures));
            handler.endSuite();
        }
    }

    private int getIntAttribute(Element element, String attribute) {
        int result = 0;
        String val = element.getAttributeValue(attribute);
        if (val != null) {
            try {
                result = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    private void loadCases(TestHandler handler, Document doc, boolean failuresOnly, Counter counter) {
        Elements elements = doc.getRootElement().getChildElements(ELEMENT_CASE);
        for (int i = 0; i < elements.size(); ++i) {
            Element element = elements.get(i);
            TestCaseResult.Status status = this.getStatus(element);
            if (failuresOnly && status == TestCaseResult.Status.PASS) continue;
            TestCaseResult caseResult = new TestCaseResult(element.getAttributeValue(ATTRIBUTE_NAME), this.getDuration(element), status, this.getMessage(element));
            if (caseResult.getStatus() == TestCaseResult.Status.PASS) {
                caseResult.setFixed(element.getAttributeValue(ATTRIBUTE_FIXED) != null);
            } else {
                caseResult.setBrokenSince(this.getLongAttribute(element, ATTRIBUTE_BROKEN_SINCE));
                caseResult.setBrokenNumber(this.getLongAttribute(element, ATTRIBUTE_BROKEN_NUMBER));
            }
            handler.handleCase(caseResult, element);
            counter.add();
            if (!counter.isExhausted()) continue;
            return;
        }
    }

    private long getLongAttribute(Element element, String attribute) {
        String value = element.getAttributeValue(attribute);
        if (value == null) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private long getDuration(Element element) {
        long result = -1L;
        String attributeValue = element.getAttributeValue(ATTRIBUTE_DURATION);
        if (attributeValue != null) {
            try {
                result = Long.parseLong(attributeValue);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    private TestCaseResult.Status getStatus(Element element) {
        TestCaseResult.Status status = TestCaseResult.Status.PASS;
        String statusName = element.getAttributeValue(ATTRIBUTE_STATUS);
        if (statusName != null) {
            try {
                status = TestCaseResult.Status.valueOf(statusName);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return status;
    }

    private String getMessage(Element element) {
        Node child;
        Elements messageElements = element.getChildElements(ELEMENT_MESSAGE);
        if (messageElements.size() > 0 && messageElements.get(0).getChildCount() > 0 && (child = messageElements.get(0).getChild(0)) instanceof Text) {
            return child.getValue();
        }
        return null;
    }

    private Document readDoc(File file) throws IOException, ParsingException {
        Builder builder = new Builder();
        return builder.build(file);
    }

    private String encodeName(String name) {
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return name;
        }
    }

    private String decodeName(String name) {
        try {
            return URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return name;
        }
    }

    private class Counter {
        public int limit;
        public int count;

        public Counter(int limit) {
            this.limit = limit;
            this.count = 0;
        }

        public void add() {
            ++this.count;
        }

        public boolean isExhausted() {
            return this.limit > 0 && this.count >= this.limit;
        }
    }
}

