/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.model.Entity;

public class TestResultSummary
extends Entity {
    private int errors;
    private int failures;
    private int total;

    public TestResultSummary() {
        this.errors = 0;
        this.failures = 0;
        this.total = 0;
    }

    public TestResultSummary(int errors, int failures, int total) {
        this.errors = errors;
        this.failures = failures;
        this.total = total;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    public void addErrors(int errors) {
        this.errors += errors;
    }

    public int getFailures() {
        return this.failures;
    }

    public void setFailures(int failures) {
        this.failures = failures;
    }

    public void addFailures(int failures) {
        this.failures += failures;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void addTotal(int total) {
        this.total += total;
    }

    public int getPassed() {
        return this.total - this.getBroken();
    }

    public int getBroken() {
        return this.errors + this.failures;
    }

    public boolean allPassed() {
        return this.errors == 0 && this.failures == 0;
    }

    public int hashCode() {
        return this.errors * 10000 + this.failures * 100 + this.total;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TestResultSummary) {
            TestResultSummary other = (TestResultSummary)obj;
            return other.errors == this.errors && other.failures == this.failures && other.total == this.total;
        }
        return false;
    }

    public void add(TestResultSummary summary) {
        this.addErrors(summary.errors);
        this.addFailures(summary.failures);
        this.addTotal(summary.total);
    }

    public boolean hasTests() {
        return this.total > 0;
    }

    public String getSuccessRate() {
        double rate = 0.0;
        if (this.hasTests()) {
            rate = (double)this.getPassed() * 100.0 / (double)this.total;
        }
        return String.format("%.2f", rate);
    }

    public String toString() {
        if (this.hasTests()) {
            if (this.allPassed()) {
                return "all " + this.total + " passed";
            }
            return Integer.toString(this.getBroken()) + " of " + this.total + " broken";
        }
        return "none";
    }
}

