/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.model.TestResultSummary;
import com.zutubi.pulse.util.TimeStamps;

public abstract class TestResult {
    public static final long UNKNOWN_DURATION = -1L;
    private String name;
    private long duration;

    protected TestResult() {
    }

    protected TestResult(String name) {
        this(name, -1L);
    }

    protected TestResult(String name, long duration) {
        this.name = name;
        this.duration = duration;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getPrettyDuration() {
        if (this.duration >= 0L) {
            return TimeStamps.getPrettyElapsed(this.duration);
        }
        return "";
    }

    public abstract int getErrors();

    public abstract int getFailures();

    public abstract int getTotal();

    public abstract boolean isSuite();

    public boolean hasBrokenTests() {
        return this.getSummary().getBroken() > 0;
    }

    public TestResultSummary getSummary() {
        return new TestResultSummary(this.getErrors(), this.getFailures(), this.getTotal());
    }

    public void accumulateSummary(TestResultSummary summary) {
        summary.addErrors(this.getErrors());
        summary.addFailures(this.getFailures());
        summary.addTotal(this.getTotal());
    }

    public boolean isEquivalent(TestResult other) {
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return this.getDuration() == other.getDuration();
    }
}

