/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.core.model.Feature;
import com.zutubi.pulse.core.model.StoredFileArtifact;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredArtifact
extends Entity {
    private static final String[] INDEX_NAMES = new String[]{"index.html", "index.htm", "default.html", "default.htm"};
    private String name;
    List<StoredFileArtifact> children = new LinkedList<StoredFileArtifact>();
    private String index;
    private String url;

    public StoredArtifact() {
    }

    public StoredArtifact(String name) {
        this.name = name;
    }

    public StoredArtifact(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public StoredArtifact(String name, StoredFileArtifact file) {
        this.name = name;
        this.children.add(file);
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public void add(StoredFileArtifact child) {
        this.children.add(child);
    }

    public List<StoredFileArtifact> getChildren() {
        return this.children;
    }

    private void setChildren(List<StoredFileArtifact> children) {
        this.children = children;
    }

    public boolean isSingleFile() {
        return this.children.size() == 1;
    }

    public StoredFileArtifact getFile() {
        return this.children.get(0);
    }

    public boolean hasFeatures() {
        for (StoredFileArtifact child : this.children) {
            if (!child.hasFeatures()) continue;
            return true;
        }
        return false;
    }

    public Iterable<Feature.Level> getLevels() {
        TreeSet<Feature.Level> result = new TreeSet<Feature.Level>();
        for (StoredFileArtifact child : this.children) {
            for (Feature.Level level : child.getLevels()) {
                result.add(level);
            }
        }
        return result;
    }

    public boolean hasMessages(Feature.Level level) {
        for (StoredFileArtifact child : this.children) {
            if (!child.hasMessages(level)) continue;
            return true;
        }
        return false;
    }

    public List<Feature> getFeatures(Feature.Level level) {
        LinkedList<Feature> result = new LinkedList<Feature>();
        for (StoredFileArtifact child : this.children) {
            result.addAll(child.getFeatures(level));
        }
        return result;
    }

    public String trimmedPath(StoredFileArtifact artifact) {
        String path = artifact.getPath();
        if (path.startsWith(this.name)) {
            path = path.substring(this.name.length());
        }
        if (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith("\\")) {
            path = path.substring(1);
        }
        return path;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public StoredFileArtifact findFile(String filePath) {
        for (StoredFileArtifact a : this.children) {
            if (!a.getPath().equals(filePath)) continue;
            return a;
        }
        return null;
    }

    public StoredFileArtifact findFileBase(String path) {
        return this.findFile(this.name + "/" + path);
    }

    public boolean hasIndexFile() {
        return this.findIndexFile() != null;
    }

    public String findIndexFile() {
        if (this.index != null && this.findFileBase(this.index) != null) {
            return this.index;
        }
        for (String index : INDEX_NAMES) {
            if (this.findFileBase(index) == null) continue;
            return index;
        }
        return null;
    }

    public boolean isLink() {
        return this.url != null;
    }
}

