/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.core.model.Feature;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.TimeStamps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Result
extends Entity {
    private static final String EXCEPTION_FILE = "exception";
    protected ResultState state = ResultState.INITIAL;
    protected TimeStamps stamps = new TimeStamps();
    private File outputDir;
    protected List<Feature> features = new LinkedList<Feature>();
    protected static final int UNDEFINED = -1;
    protected int warningFeatureCount = -1;
    protected int errorFeatureCount = -1;

    public boolean pending() {
        return ResultState.INITIAL == this.getState();
    }

    public boolean inProgress() {
        return ResultState.IN_PROGRESS == this.getState();
    }

    public boolean terminating() {
        return ResultState.TERMINATING == this.getState();
    }

    public boolean succeeded() {
        return ResultState.SUCCESS == this.getState();
    }

    public boolean failed() {
        return ResultState.FAILURE == this.getState();
    }

    public boolean errored() {
        return ResultState.ERROR == this.getState();
    }

    public boolean commenced() {
        return this.inProgress() || this.terminating() || this.completed();
    }

    public boolean completed() {
        return this.succeeded() || this.errored() || this.failed();
    }

    public void queue() {
        this.stamps.setQueueTime(System.currentTimeMillis());
    }

    public void commence() {
        this.commence(System.currentTimeMillis());
    }

    public void commence(long startTime) {
        this.stamps.setStartTime(startTime);
        if (this.state != ResultState.TERMINATING) {
            this.state = ResultState.IN_PROGRESS;
        }
    }

    public void complete() {
        this.complete(System.currentTimeMillis());
    }

    public void complete(long endTime) {
        if (this.state == ResultState.IN_PROGRESS) {
            this.state = ResultState.SUCCESS;
        } else if (this.state == ResultState.TERMINATING) {
            this.state = ResultState.ERROR;
        }
        if (!this.stamps.started()) {
            this.stamps.setStartTime(endTime);
        }
        this.stamps.setEndTime(endTime);
    }

    public void success() {
        this.state = ResultState.SUCCESS;
    }

    public void failure() {
        this.state = ResultState.FAILURE;
    }

    public void addFeature(Feature.Level level, String message) {
        Feature feature = new Feature(level, message);
        for (Feature f : this.features) {
            if (!feature.equals(f)) continue;
            return;
        }
        this.features.add(feature);
    }

    public void failure(String message) {
        this.failure();
        this.addFeature(Feature.Level.ERROR, message);
    }

    public void error(String message) {
        this.state = ResultState.ERROR;
        this.addFeature(Feature.Level.ERROR, message);
    }

    public void warning(String message) {
        this.addFeature(Feature.Level.WARNING, message);
    }

    public void terminate(boolean timeout) {
        this.state = ResultState.TERMINATING;
        if (timeout) {
            this.addFeature(Feature.Level.ERROR, "Timed out");
        } else {
            this.addFeature(Feature.Level.ERROR, "Forcefully terminated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void error(BuildException e) {
        this.error(e.getMessage());
        if (this.outputDir != null) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(new File(this.outputDir, EXCEPTION_FILE));
                e.printStackTrace(new PrintStream(fos, true));
            }
            catch (FileNotFoundException fileNotFoundException) {
                IOUtils.close(fos);
                catch (Throwable throwable) {
                    IOUtils.close(fos);
                    throw throwable;
                }
            }
            IOUtils.close(fos);
        }
    }

    public ResultState getState() {
        return this.state;
    }

    public void setState(ResultState state) {
        this.state = state;
    }

    public String getStateName() {
        return this.state.name();
    }

    private void setStateName(String name) {
        this.state = ResultState.valueOf(name);
    }

    public TimeStamps getStamps() {
        return this.stamps;
    }

    private void setStamps(TimeStamps stamps) {
        this.stamps = stamps;
    }

    public String getExceptionTrace() {
        File exceptionFile = new File(this.outputDir, EXCEPTION_FILE);
        String result = null;
        try {
            result = IOUtils.fileToString(exceptionFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public File getAbsoluteOutputDir(File dataRoot) {
        return new File(dataRoot, this.outputDir.getPath());
    }

    public void setAbsoluteOutputDir(File dataRoot, File outputDir) {
        String dataPath = dataRoot.getAbsolutePath();
        String outputPath = outputDir.getAbsolutePath();
        if (outputPath.startsWith(dataPath) && ((outputPath = outputPath.substring(dataPath.length())).startsWith(File.separator) || outputPath.startsWith("/"))) {
            outputPath = outputPath.substring(1);
        }
        this.outputDir = new File(outputPath);
    }

    public String getOutputDir() {
        if (this.outputDir == null) {
            return null;
        }
        return this.outputDir.getPath();
    }

    public void setOutputDir(String dir) {
        this.outputDir = dir == null ? null : new File(dir);
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public List<Feature> getFeatures(Feature.Level level) {
        LinkedList<Feature> result = new LinkedList<Feature>();
        for (Feature f : this.features) {
            if (f.getLevel() != level) continue;
            result.add(f);
        }
        return result;
    }

    private void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public List<String> collectErrors() {
        LinkedList<String> errors = new LinkedList<String>();
        for (Feature f : this.features) {
            if (f.getLevel() != Feature.Level.ERROR) continue;
            errors.add(f.getSummary());
        }
        return errors;
    }

    public boolean hasDirectMessages(Feature.Level level) {
        for (Feature f : this.features) {
            if (f.getLevel() != level) continue;
            return true;
        }
        return false;
    }

    public Feature.Level getLevel(String name) {
        return Feature.Level.valueOf(name);
    }

    public int getWarningFeatureCount() {
        return this.warningFeatureCount;
    }

    public void setWarningFeatureCount(int count) {
        this.warningFeatureCount = count;
    }

    public int getErrorFeatureCount() {
        return this.errorFeatureCount;
    }

    public void setErrorFeatureCount(int count) {
        this.errorFeatureCount = count;
    }

    public void calculateFeatureCounts() {
        this.warningFeatureCount = 0;
        this.errorFeatureCount = 0;
        for (Feature f : this.features) {
            if (f.getLevel() == Feature.Level.ERROR) {
                ++this.errorFeatureCount;
            }
            if (f.getLevel() != Feature.Level.WARNING) continue;
            ++this.warningFeatureCount;
        }
    }
}

