/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.core.model.ResourceProperty;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceVersion
extends Entity {
    private String value;
    private Map<String, ResourceProperty> properties = new TreeMap<String, ResourceProperty>();

    public ResourceVersion() {
    }

    public ResourceVersion(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Map<String, ResourceProperty> getProperties() {
        return this.properties;
    }

    private void setProperties(Map<String, ResourceProperty> properties) {
        this.properties = properties;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public ResourceProperty getProperty(String name) {
        return this.properties.get(name);
    }

    public void addProperty(ResourceProperty p) throws FileLoadException {
        String name = p.getName();
        if (this.hasProperty(name)) {
            throw new FileLoadException("Property with name '" + name + "' already exists with value '" + this.properties.get(name).getValue() + "'");
        }
        this.properties.put(name, p);
    }

    public void deleteProperty(String name) {
        this.properties.remove(name);
    }
}

