/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.model.Feature;

public class PlainFeature
extends Feature {
    private long firstLine;
    private long lastLine;
    private long lineNumber;

    public PlainFeature() {
    }

    public PlainFeature(Feature.Level level, String summary, long lineNumber) {
        super(level, summary);
        this.lineNumber = lineNumber;
        this.firstLine = lineNumber;
        this.lastLine = lineNumber;
    }

    public PlainFeature(Feature.Level level, String summary, long firstLine, long lastLine, long lineNumber) {
        super(level, summary);
        this.firstLine = firstLine;
        this.lastLine = lastLine;
        this.lineNumber = lineNumber;
    }

    public long getFirstLine() {
        return this.firstLine;
    }

    public void setFirstLine(long firstLine) {
        this.firstLine = firstLine;
    }

    public long getLastLine() {
        return this.lastLine;
    }

    public void setLastLine(long lastLine) {
        this.lastLine = lastLine;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    private void setLineNumber(long line) {
        this.lineNumber = line;
    }

    public boolean isPlain() {
        return true;
    }

    public boolean hasLeadingContext() {
        return this.lineNumber > this.firstLine;
    }

    public boolean hasTrailingContext() {
        return this.lineNumber < this.lastLine;
    }

    public boolean hasContext() {
        return this.hasLeadingContext() || this.hasTrailingContext();
    }

    public int lineOffset() {
        return (int)(this.lineNumber - this.firstLine + 1L);
    }

    public String[] getSummaryLines() {
        return this.getSummary().split("\n");
    }

    public boolean equals(Object o) {
        if (o instanceof PlainFeature) {
            PlainFeature other = (PlainFeature)o;
            return super.equals(o) && other.firstLine == this.firstLine && other.lineNumber == this.lineNumber && other.lastLine == this.lastLine;
        }
        return super.equals(o);
    }
}

