/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.scm.SCMException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CvsRevision
extends Revision {
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
    public static final CvsRevision HEAD = new CvsRevision(null, null, null, null);

    protected CvsRevision() {
    }

    public CvsRevision(String author, String tag, String comment, Date date) {
        this.setAuthor(author);
        this.setBranch(tag);
        this.setComment(comment);
        this.setDate(date);
        this.setRevisionString(this.generateRevisionString());
    }

    public CvsRevision(String revisionString) throws SCMException {
        String[] parts = revisionString.split(":");
        if (parts.length == 1) {
            this.setDate(revisionString, revisionString, new SimpleDateFormat("yyyyMMdd"));
        } else if (parts.length == 3) {
            this.setDate(revisionString, revisionString, DATE_FORMAT);
        } else if (parts.length == 5) {
            parts = revisionString.split(":", 3);
            if (parts[0].length() > 0) {
                this.setAuthor(parts[0]);
            }
            if (parts[1].length() > 0) {
                this.setBranch(parts[1]);
            }
            if (parts[2].length() > 0) {
                this.setDate(parts[2], revisionString, DATE_FORMAT);
            }
        } else {
            throw new SCMException("Invalid CVS revision '" + revisionString + "' (must be a date, or <author>:<branch>:<date>)");
        }
        this.setRevisionString(this.generateRevisionString());
    }

    private void setDate(String s, String revisionString, DateFormat dateFormat) throws SCMException {
        try {
            this.setDate(dateFormat.parse(s));
        }
        catch (ParseException e) {
            throw new SCMException("Invalid CVS revision '" + revisionString + "': date is invalid: " + e.getMessage());
        }
    }

    private String generateRevisionString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getAuthor() != null ? this.getAuthor() : "");
        buffer.append(":");
        buffer.append(this.getBranch() != null ? this.getBranch() : "");
        buffer.append(":");
        buffer.append(this.getDate() != null ? DATE_FORMAT.format(this.getDate()) : "");
        return buffer.toString();
    }

    public Revision copy() {
        CvsRevision copy = new CvsRevision();
        this.copyCommon(copy);
        return copy;
    }

    public boolean isHead() {
        return this.getAuthor() == null && this.getBranch() == null && this.getComment() == null && this.getDate() == null;
    }
}

