/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core.model;

import com.zutubi.pulse.core.model.Feature;
import com.zutubi.pulse.core.model.Result;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.core.model.StoredArtifact;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandResult
extends Result {
    private String commandName;
    private Properties properties;
    private List<StoredArtifact> artifacts = new LinkedList<StoredArtifact>();

    protected CommandResult() {
    }

    public CommandResult(String name) {
        this.commandName = name;
        this.state = ResultState.INITIAL;
    }

    public String getCommandName() {
        return this.commandName;
    }

    private void setCommandName(String name) {
        this.commandName = name;
    }

    public void addArtifact(StoredArtifact artifact) {
        this.artifacts.add(artifact);
    }

    public StoredArtifact getArtifact(String name) {
        for (StoredArtifact a : this.artifacts) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public List<StoredArtifact> getArtifacts() {
        return this.artifacts;
    }

    private void setArtifacts(List<StoredArtifact> artifacts) {
        this.artifacts = artifacts;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    private void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean hasMessages(Feature.Level level) {
        if (this.hasDirectMessages(level)) {
            return true;
        }
        for (StoredArtifact artifact : this.artifacts) {
            if (!artifact.hasMessages(level)) continue;
            return true;
        }
        return false;
    }

    public boolean hasArtifacts() {
        return this.artifacts.size() > 0;
    }

    @Override
    public void calculateFeatureCounts() {
        super.calculateFeatureCounts();
        for (StoredArtifact artifact : this.artifacts) {
            this.warningFeatureCount += artifact.getFeatures(Feature.Level.WARNING).size();
            this.errorFeatureCount += artifact.getFeatures(Feature.Level.ERROR).size();
        }
    }
}

