/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.TestReportPostProcessor;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.TestSuiteResult;
import com.zutubi.pulse.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Text;

public abstract class XMLReportPostProcessor
extends TestReportPostProcessor {
    private String reportType;

    protected XMLReportPostProcessor(String reportType) {
        this.reportType = reportType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void internalProcess(CommandResult result, File file, TestSuiteResult suite) {
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            Builder builder = new Builder();
            Document doc = builder.build((InputStream)input);
            this.processDocument(doc, suite);
        }
        catch (ParsingException pex) {
            String message = "Unable to parse " + this.reportType + " report '" + file.getAbsolutePath() + "'";
            if (pex.getMessage() != null) {
                message = message + ": " + pex.getMessage();
            }
            result.warning(message);
            IOUtils.close(input);
        }
        catch (IOException e) {
            String message = "I/O error processing " + this.reportType + " report '" + file.getAbsolutePath() + "'";
            if (e.getMessage() != null) {
                message = message + ": " + e.getMessage();
            }
            result.warning(message);
            {
                catch (Throwable throwable) {
                    IOUtils.close(input);
                    throw throwable;
                }
            }
            IOUtils.close(input);
        }
        IOUtils.close(input);
    }

    protected String getText(Element element) {
        Node child;
        if (element.getChildCount() > 0 && (child = element.getChild(0)) != null && child instanceof Text) {
            return child.getValue().trim();
        }
        return null;
    }

    protected abstract void processDocument(Document var1, TestSuiteResult var2);
}

