/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.Reference;
import com.zutubi.pulse.core.Scope;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableHelper {
    private static List<Token> tokenise(String input, boolean split) throws FileLoadException {
        LinkedList<Token> result = new LinkedList<Token>();
        LexerState state = LexerState.INITIAL;
        StringBuilder current = new StringBuilder();
        boolean quoted = false;
        boolean haveData = false;
        block24: for (int i = 0; i < input.length(); ++i) {
            char inputChar = input.charAt(i);
            switch (state) {
                case INITIAL: {
                    switch (inputChar) {
                        case '\\': {
                            state = LexerState.ESCAPED;
                            continue block24;
                        }
                        case '\"': {
                            if (split) {
                                if (quoted) {
                                    quoted = false;
                                    continue block24;
                                }
                                quoted = true;
                                haveData = true;
                                continue block24;
                            }
                            current.append(inputChar);
                            haveData = true;
                            continue block24;
                        }
                        case ' ': {
                            if (split) {
                                if (quoted) {
                                    current.append(inputChar);
                                    haveData = true;
                                    continue block24;
                                }
                                VariableHelper.addCurrent(current, haveData, result);
                                haveData = false;
                                result.add(new Token(TokenType.SPACE, " "));
                                continue block24;
                            }
                            current.append(inputChar);
                            haveData = true;
                            continue block24;
                        }
                        case '$': {
                            state = LexerState.DOLLAR;
                            VariableHelper.addCurrent(current, haveData, result);
                            haveData = false;
                            continue block24;
                        }
                    }
                    current.append(inputChar);
                    haveData = true;
                    continue block24;
                }
                case ESCAPED: {
                    current.append(inputChar);
                    haveData = true;
                    state = LexerState.INITIAL;
                    continue block24;
                }
                case DOLLAR: {
                    switch (inputChar) {
                        case '{': {
                            state = LexerState.VARIABLE;
                            continue block24;
                        }
                    }
                    throw new FileLoadException("Syntax error: expecting '{', got '" + inputChar + "'");
                }
                case VARIABLE: {
                    switch (inputChar) {
                        case '}': {
                            if (current.length() == 0) {
                                throw new FileLoadException("Syntax error: empty variable reference");
                            }
                            result.add(new Token(TokenType.VARIABLE_REFERENCE, current.toString()));
                            state = LexerState.INITIAL;
                            current.delete(0, current.length());
                            continue block24;
                        }
                    }
                    current.append(inputChar);
                }
            }
        }
        switch (state) {
            case INITIAL: {
                if (quoted) {
                    throw new FileLoadException("Syntax error: unexpected end of input looking for closing quotes (\")");
                }
                VariableHelper.addCurrent(current, haveData, result);
                break;
            }
            case ESCAPED: {
                throw new FileLoadException("Syntax error: unexpected end of input in escape sequence (\\)");
            }
            case DOLLAR: {
                throw new FileLoadException("Syntax error: unexpected end of input looking for '{'");
            }
            case VARIABLE: {
                throw new FileLoadException("Syntax error: unexpected end of input looking for '}'");
            }
        }
        return result;
    }

    private static void addCurrent(StringBuilder current, boolean haveData, List<Token> result) {
        if (haveData) {
            result.add(new Token(TokenType.TEXT, current.toString()));
            current.delete(0, current.length());
        }
    }

    public static boolean containsVariables(String input) throws FileLoadException {
        List<Token> tokens = VariableHelper.tokenise(input, false);
        for (Token token : tokens) {
            switch (token.type) {
                case VARIABLE_REFERENCE: {
                    return true;
                }
            }
        }
        return false;
    }

    public static Object replaceVariable(String input, Scope properties) throws FileLoadException {
        List<Token> tokens = VariableHelper.tokenise(input, false);
        if (tokens.size() != 1 || tokens.get((int)0).type != TokenType.VARIABLE_REFERENCE) {
            throw new FileLoadException("Expected single variable reference. Instead found '" + input + "'");
        }
        Token token = tokens.get(0);
        Reference ref = properties.getReference(token.value);
        if (ref != null) {
            return ref.getValue();
        }
        throw new FileLoadException("Unknown variable reference '" + token.value + "'");
    }

    public static String replaceVariables(String input, Scope properties) throws FileLoadException {
        return VariableHelper.replaceVariables(input, properties, false);
    }

    public static String replaceVariables(String input, Scope properties, boolean allowUnresolved) throws FileLoadException {
        StringBuilder result = new StringBuilder();
        List<Token> tokens = VariableHelper.tokenise(input, false);
        for (Token token : tokens) {
            switch (token.type) {
                case TEXT: {
                    result.append(token.value);
                    break;
                }
                case VARIABLE_REFERENCE: {
                    result.append(VariableHelper.resolveReference(properties, token, allowUnresolved));
                }
            }
        }
        return result.toString();
    }

    public static List<String> splitAndReplaceVariables(String input, Scope properties, boolean allowUnresolved) throws FileLoadException {
        LinkedList<String> result = new LinkedList<String>();
        StringBuilder current = new StringBuilder();
        boolean haveData = false;
        List<Token> tokens = VariableHelper.tokenise(input, true);
        for (Token token : tokens) {
            switch (token.type) {
                case SPACE: {
                    if (!haveData) break;
                    result.add(current.toString());
                    current.delete(0, current.length());
                    haveData = false;
                    break;
                }
                case TEXT: {
                    current.append(token.value);
                    haveData = true;
                    break;
                }
                case VARIABLE_REFERENCE: {
                    String value = VariableHelper.resolveReference(properties, token, allowUnresolved);
                    if (value.length() <= 0) break;
                    current.append(value);
                    haveData = true;
                    break;
                }
            }
        }
        if (haveData) {
            result.add(current.toString());
        }
        return result;
    }

    private static String resolveReference(Scope properties, Token token, boolean allowUnresolved) throws FileLoadException {
        if (properties.containsReference(token.value)) {
            Object obj = properties.getReference(token.value).getValue();
            if (!(obj instanceof String)) {
                throw new FileLoadException("Reference to non string variable '" + token.value + "'");
            }
            return obj.toString();
        }
        if (allowUnresolved) {
            return "${" + token.value + "}";
        }
        throw new FileLoadException("Reference to unknown variable '" + token.value + "'");
    }

    private static class Token {
        public TokenType type;
        public String value;

        public Token(TokenType type, String value) {
            this.type = type;
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LexerState {
        INITIAL,
        ESCAPED,
        DOLLAR,
        VARIABLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TokenType {
        SPACE,
        TEXT,
        VARIABLE_REFERENCE;

    }
}

