/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.PostProcessor;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredFileArtifact;
import com.zutubi.pulse.core.model.TestSuiteResult;
import java.io.File;

public abstract class TestReportPostProcessor
implements PostProcessor {
    private String name;
    private String suite;
    private boolean failOnFailure = true;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSuite(String suite) {
        this.suite = suite;
    }

    public boolean getFailOnFailure() {
        return this.failOnFailure;
    }

    public void setFailOnFailure(boolean failOnFailure) {
        this.failOnFailure = failOnFailure;
    }

    public void process(StoredFileArtifact artifact, CommandResult result, CommandContext context) {
        int brokenBefore = context.getTestResults().getSummary().getBroken();
        File file = new File(context.getOutputDir(), artifact.getPath());
        if (file.isFile()) {
            int brokenAfter;
            TestSuiteResult parentSuite = this.suite == null ? context.getTestResults() : new TestSuiteResult(this.suite);
            this.internalProcess(result, file, parentSuite);
            if (this.suite != null) {
                context.getTestResults().add(parentSuite);
            }
            if (this.failOnFailure && !result.failed() && !result.errored() && (brokenAfter = context.getTestResults().getSummary().getBroken()) > brokenBefore) {
                result.failure("One or more test cases failed.");
            }
        }
    }

    protected abstract void internalProcess(CommandResult var1, File var2, TestSuiteResult var3);

    public Object getValue() {
        return this;
    }
}

