/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.CommandSupport;
import com.zutubi.pulse.core.model.CommandResult;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class SleepCommand
extends CommandSupport {
    private int interval;
    private Semaphore terminatedSemaphore = new Semaphore(0);

    public void execute(CommandContext context, CommandResult result) {
        try {
            if (this.terminatedSemaphore.tryAcquire(this.interval, TimeUnit.MILLISECONDS)) {
                result.error("Terminated");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void terminate() {
        this.terminatedSemaphore.release();
    }
}

