/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.Reference;
import com.zutubi.pulse.core.VariableHelper;
import com.zutubi.pulse.core.model.Property;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.util.Sort;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scope {
    private static final Logger LOG = Logger.getLogger(Scope.class);
    private static final boolean RETAIN_ENVIRONMENT_CASE = System.getProperty("pulse.retain.environment.case") != null;
    private Scope parent;
    private List<ReferenceInfo> references = new LinkedList<ReferenceInfo>();

    public Scope() {
    }

    public Scope(Scope parent) {
        this.parent = parent;
    }

    public Scope getParent() {
        return this.parent;
    }

    public List<Reference> getReferences() {
        ArrayList<Reference> result = new ArrayList<Reference>(this.references.size());
        for (ReferenceInfo info : this.references) {
            result.add(info.reference);
        }
        final Sort.StringComparator stringComp = new Sort.StringComparator();
        Collections.sort(result, new Comparator<Reference>(){

            @Override
            public int compare(Reference r1, Reference r2) {
                return stringComp.compare(r1.getName(), r2.getName());
            }
        });
        return result;
    }

    public boolean containsReference(String name) {
        return this.getReference(name) != null;
    }

    public Reference getReference(String name) {
        if (name.startsWith("env.")) {
            if (name.equalsIgnoreCase("env.path")) {
                return this.lookupPath(name);
            }
            return this.lookupEnvironment(name);
        }
        ReferenceInfo info = this.directLookup(name, this.references);
        if (info != null) {
            return info.reference;
        }
        if (this.parent != null) {
            return this.parent.getReference(name);
        }
        return null;
    }

    private Reference lookupPath(String name) {
        LinkedList<ReferenceInfo> merged = new LinkedList<ReferenceInfo>();
        this.merge(merged);
        ReferenceInfo info = this.directLookup(name, merged, false);
        String value = info == null || !(info.reference.getValue() instanceof String) ? "" : (String)info.reference.getValue();
        return new Property(name, this.getPathPrefix() + value);
    }

    private Reference lookupEnvironment(String name) {
        LinkedList<ReferenceInfo> merged = new LinkedList<ReferenceInfo>();
        this.merge(merged);
        Map<String, String> env = this.getEnvironment(merged);
        String var = name.substring(4);
        String value = env.get(var);
        if (value == null) {
            ReferenceInfo info = this.directLookup(name, merged);
            if (info == null) {
                return null;
            }
            return info.reference;
        }
        return new Property(name, value);
    }

    public void setReference(Reference reference) throws FileLoadException {
        if (this.directLookup(reference.getName(), this.references) != null) {
            throw new FileLoadException("'" + reference.getName() + "' is already defined in this scope.");
        }
        this.add(reference);
    }

    public void add(Reference reference) {
        this.add(new ReferenceInfo(reference));
    }

    private void add(ReferenceInfo info) {
        this.references.add(0, info);
    }

    public <V extends Reference> void add(List<V> references) throws FileLoadException {
        for (Reference r : references) {
            this.setReference(r);
        }
    }

    public <V extends Reference> void add(Map<String, V> references) throws FileLoadException {
        for (Reference v : references.values()) {
            this.setReference(v);
        }
    }

    public Map<String, String> getEnvironment() {
        LinkedList<ReferenceInfo> merged = new LinkedList<ReferenceInfo>();
        this.merge(merged);
        return this.getEnvironment(merged);
    }

    private Map<String, String> getEnvironment(List<ReferenceInfo> merged) {
        TreeMap<String, String> env = new TreeMap<String, String>();
        for (ReferenceInfo i : merged) {
            if (!i.addToEnvironment) continue;
            env.put(i.reference.getName(), (String)i.reference.getValue());
        }
        return env;
    }

    public List<String> getPathDirectories() {
        LinkedList<ReferenceInfo> merged = new LinkedList<ReferenceInfo>();
        this.merge(merged);
        LinkedList<String> dirs = new LinkedList<String>();
        for (ReferenceInfo i : merged) {
            if (!i.addToPath) continue;
            dirs.add((String)i.reference.getValue());
        }
        return dirs;
    }

    public String getPathPrefix() {
        String result = "";
        for (String dir : this.getPathDirectories()) {
            result = result + dir;
            result = result + File.pathSeparatorChar;
        }
        return result;
    }

    public void add(Collection<ResourceProperty> properties) {
        for (ResourceProperty resourceProperty : properties) {
            this.add(resourceProperty);
        }
    }

    public void add(ResourceProperty resourceProperty) {
        this.add(new ReferenceInfo(resourceProperty));
    }

    public void addEnvironmentProperty(String name, String value) {
        if (!RETAIN_ENVIRONMENT_CASE) {
            name = name.toUpperCase();
        }
        this.add(new Property("env." + name, value));
    }

    private ReferenceInfo directLookup(String name, List<ReferenceInfo> references) {
        return this.directLookup(name, references, true);
    }

    private ReferenceInfo directLookup(String name, List<ReferenceInfo> references, boolean caseSensitive) {
        if (!caseSensitive) {
            name = name.toLowerCase();
        }
        for (ReferenceInfo i : references) {
            String referenceName = i.reference.getName();
            if (!caseSensitive) {
                referenceName = referenceName.toLowerCase();
            }
            if (!referenceName.equals(name)) continue;
            return i;
        }
        return null;
    }

    private void merge(List<ReferenceInfo> merged) {
        for (ReferenceInfo i : this.references) {
            if (this.directLookup(i.reference.getName(), merged) != null) continue;
            merged.add(i);
        }
        if (this.parent != null) {
            this.parent.merge(merged);
        }
    }

    private class ReferenceInfo {
        public Reference reference;
        public boolean addToPath;
        public boolean addToEnvironment;

        public ReferenceInfo(Reference reference) {
            this.reference = reference;
            this.addToPath = false;
            this.addToEnvironment = false;
        }

        public ReferenceInfo(ResourceProperty p) {
            String value = p.getValue();
            if (p.getResolveVariables()) {
                try {
                    value = VariableHelper.replaceVariables(p.getValue(), Scope.this, true);
                }
                catch (FileLoadException e) {
                    // empty catch block
                }
            }
            this.reference = new Property(p.getName(), value);
            this.addToPath = p.getAddToPath();
            this.addToEnvironment = p.getAddToEnvironment();
        }

        public String toString() {
            return this.reference.getName() + " -> " + this.reference.getValue() + " [path: " + this.addToPath + ", env: " + this.addToEnvironment + "]";
        }
    }
}

