/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.model.Feature;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexPattern {
    private Feature.Level category = Feature.Level.ERROR;
    private String expression;
    private String summary;
    private Pattern pattern;
    private List<Exclusion> exclusions;

    public RegexPattern() {
        this.exclusions = new LinkedList<Exclusion>();
    }

    public RegexPattern(Feature.Level category, Pattern pattern) {
        this.category = category;
        this.pattern = pattern;
        this.expression = pattern.pattern();
        this.exclusions = new LinkedList<Exclusion>();
    }

    public Feature.Level getCategory() {
        return this.category;
    }

    public void setCategory(Feature.Level level) {
        this.category = level;
    }

    public void setCategory(String category) throws FileLoadException {
        try {
            this.category = Feature.Level.valueOf(category.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new FileLoadException("Unrecognised regex category '" + category + "'");
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) throws FileLoadException {
        try {
            this.pattern = Pattern.compile(expression);
            this.expression = expression;
        }
        catch (PatternSyntaxException e) {
            throw new FileLoadException(e);
        }
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Exclusion createExclude() {
        Exclusion exclusion = new Exclusion();
        this.exclusions.add(exclusion);
        return exclusion;
    }

    public String match(String line) {
        String result = null;
        Matcher matcher = this.pattern.matcher(line);
        if (matcher.find()) {
            for (Exclusion e : this.exclusions) {
                if (!e.getPattern().matcher(line).find()) continue;
                return null;
            }
            result = this.summary == null ? line : matcher.replaceAll(this.summary);
        }
        return result;
    }

    public void addExclusion(Pattern pattern) {
        this.exclusions.add(new Exclusion(pattern));
    }

    public class Exclusion {
        private String expression;
        private Pattern pattern;

        public Exclusion() {
        }

        public Exclusion(Pattern pattern) {
            this.pattern = pattern;
            this.expression = pattern.pattern();
        }

        public String getExpression() {
            return this.expression;
        }

        public void setPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        public void setExpression(String expression) throws FileLoadException {
            try {
                this.pattern = Pattern.compile(expression);
                this.expression = expression;
            }
            catch (PatternSyntaxException e) {
                throw new FileLoadException(e);
            }
        }

        public Pattern getPattern() {
            return this.pattern;
        }
    }
}

