/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.Bootstrapper;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.model.ResourceRequirement;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipeRequest {
    private String project;
    private String spec;
    private boolean incremental;
    private long id;
    private Bootstrapper bootstrapper;
    private String pulseFileSource;
    private String recipeName;
    private List<ResourceRequirement> resourceRequirements;
    private List<ResourceProperty> properties;

    public RecipeRequest(String project, String spec, long id, String recipeName, boolean incremental) {
        this(project, spec, id, recipeName, incremental, null, null);
    }

    public RecipeRequest(String project, String spec, long id, String recipeName, boolean incremental, List<ResourceRequirement> resourceRequirements, List<ResourceProperty> properties) {
        this(project, spec, id, null, null, recipeName, incremental, resourceRequirements, properties);
    }

    public RecipeRequest(long id, Bootstrapper bootstrapper, String pulseFileSource, String recipeName) {
        this(null, null, id, bootstrapper, pulseFileSource, recipeName, false, null, null);
    }

    public RecipeRequest(String project, String spec, long id, Bootstrapper bootstrapper, String pulseFileSource, String recipeName, boolean incremental) {
        this(project, spec, id, bootstrapper, pulseFileSource, recipeName, incremental, null, null);
    }

    public RecipeRequest(String project, String spec, long id, Bootstrapper bootstrapper, String pulseFileSource, String recipeName, boolean incremental, List<ResourceRequirement> resourceRequirements, List<ResourceProperty> properties) {
        this.project = project;
        this.spec = spec;
        this.id = id;
        this.bootstrapper = bootstrapper;
        this.pulseFileSource = pulseFileSource;
        this.recipeName = recipeName;
        this.incremental = incremental;
        this.resourceRequirements = resourceRequirements;
        this.properties = properties;
    }

    public String getProject() {
        return this.project;
    }

    public String getSpec() {
        return this.spec;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public long getId() {
        return this.id;
    }

    public Bootstrapper getBootstrapper() {
        return this.bootstrapper;
    }

    public String getPulseFileSource() {
        return this.pulseFileSource;
    }

    public String getRecipeName() {
        return this.recipeName;
    }

    public String getRecipeNameSafe() {
        if (this.recipeName == null) {
            return "[default]";
        }
        return this.recipeName;
    }

    public void setBootstrapper(Bootstrapper bootstrapper) {
        this.bootstrapper = bootstrapper;
    }

    public void setPulseFileSource(String pulseFileSource) {
        this.pulseFileSource = pulseFileSource;
    }

    public List<ResourceRequirement> getResourceRequirements() {
        return this.resourceRequirements;
    }

    public void setResourceRequirements(List<ResourceRequirement> resourceRequirements) {
        this.resourceRequirements = resourceRequirements;
    }

    public List<ResourceProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<ResourceProperty> properties) {
        this.properties = properties;
    }

    public void prepare(String agent) {
        this.bootstrapper.prepare(agent);
    }
}

