/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.BuildContext;
import com.zutubi.pulse.core.BootstrapCommand;
import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.Command;
import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.CommandOutputStream;
import com.zutubi.pulse.core.FileLoader;
import com.zutubi.pulse.core.ParseException;
import com.zutubi.pulse.core.PulseFile;
import com.zutubi.pulse.core.Recipe;
import com.zutubi.pulse.core.RecipeLoadPredicate;
import com.zutubi.pulse.core.RecipePaths;
import com.zutubi.pulse.core.RecipeRequest;
import com.zutubi.pulse.core.ResourceRepository;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.Property;
import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.core.model.Resource;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.core.model.ResourceVersion;
import com.zutubi.pulse.core.model.TestSuitePersister;
import com.zutubi.pulse.core.model.TestSuiteResult;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.events.build.CommandCommencedEvent;
import com.zutubi.pulse.events.build.CommandCompletedEvent;
import com.zutubi.pulse.events.build.RecipeCommencedEvent;
import com.zutubi.pulse.events.build.RecipeCompletedEvent;
import com.zutubi.pulse.model.ResourceRequirement;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipeProcessor {
    private static final Logger LOG = Logger.getLogger(RecipeProcessor.class);
    private EventManager eventManager;
    private Lock runningLock = new ReentrantLock();
    private long runningRecipe = 0L;
    private Command runningCommand = null;
    private boolean terminating = false;
    private FileLoader fileLoader;

    public void init() {
    }

    public static String getCommandDirName(int i, CommandResult result) {
        return String.format("%08d-%s", i, result.getCommandName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(RecipeRequest request, RecipePaths paths, ResourceRepository resourceRepository, boolean capture, BuildContext context) {
        RecipeResult result = new RecipeResult(request.getRecipeName());
        TestSuiteResult testResults = new TestSuiteResult();
        result.setId(request.getId());
        result.commence();
        this.runningRecipe = request.getId();
        this.eventManager.publish(new RecipeCommencedEvent(this, request.getId(), request.getRecipeName(), result.getStamps().getStartTime()));
        try {
            block15: {
                try {
                    long recipeStartTime = result.getStamps().getStartTime();
                    BootstrapCommand bootstrapCommand = new BootstrapCommand(request.getBootstrapper());
                    CommandResult bootstrapResult = new CommandResult(bootstrapCommand.getName());
                    File commandOutput = new File(paths.getOutputDir(), RecipeProcessor.getCommandDirName(0, bootstrapResult));
                    Scope globalScope = new Scope();
                    if (!this.executeCommand(request.getId(), globalScope, recipeStartTime, bootstrapResult, paths, commandOutput, testResults, bootstrapCommand, capture, context) || !bootstrapResult.succeeded()) break block15;
                    PulseFile pulseFile = this.loadPulseFile(request, paths.getBaseDir(), resourceRepository, globalScope, context, recipeStartTime);
                    String recipeName = request.getRecipeName();
                    if (recipeName == null && (recipeName = pulseFile.getDefaultRecipe()) == null) {
                        throw new BuildException("Please specify a default recipe for your project.");
                    }
                    Recipe recipe = pulseFile.getRecipe(recipeName);
                    if (recipe == null) {
                        throw new BuildException("Undefined recipe '" + recipeName + "'");
                    }
                    this.build(request.getId(), globalScope, recipeStartTime, recipe, paths, testResults, capture, context);
                }
                catch (BuildException e) {
                    result.error(e);
                    Object var18_19 = null;
                    this.writeTestResults(paths, testResults);
                    result.setTestSummary(testResults.getSummary());
                    result.complete();
                    RecipeCompletedEvent completedEvent = new RecipeCompletedEvent((Object)this, result);
                    if (context != null) {
                        completedEvent.setBuildVersion(context.getBuildVersion());
                    }
                    this.eventManager.publish(completedEvent);
                    this.runningLock.lock();
                    this.runningRecipe = 0L;
                    this.runningCommand = null;
                    if (this.terminating) {
                        this.terminating = false;
                    }
                    this.runningLock.unlock();
                    return;
                }
                catch (Exception e) {
                    LOG.severe(e);
                    result.error(new BuildException("Unexpected error: " + e.getMessage(), e));
                    Object var18_20 = null;
                    this.writeTestResults(paths, testResults);
                    result.setTestSummary(testResults.getSummary());
                    result.complete();
                    RecipeCompletedEvent completedEvent = new RecipeCompletedEvent((Object)this, result);
                    if (context != null) {
                        completedEvent.setBuildVersion(context.getBuildVersion());
                    }
                    this.eventManager.publish(completedEvent);
                    this.runningLock.lock();
                    this.runningRecipe = 0L;
                    this.runningCommand = null;
                    if (this.terminating) {
                        this.terminating = false;
                    }
                    this.runningLock.unlock();
                    return;
                }
            }
            Object var18_18 = null;
            this.writeTestResults(paths, testResults);
            result.setTestSummary(testResults.getSummary());
            result.complete();
            RecipeCompletedEvent completedEvent = new RecipeCompletedEvent((Object)this, result);
            if (context != null) {
                completedEvent.setBuildVersion(context.getBuildVersion());
            }
            this.eventManager.publish(completedEvent);
            this.runningLock.lock();
            this.runningRecipe = 0L;
            this.runningCommand = null;
            if (this.terminating) {
                this.terminating = false;
            }
            this.runningLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            this.writeTestResults(paths, testResults);
            result.setTestSummary(testResults.getSummary());
            result.complete();
            RecipeCompletedEvent completedEvent = new RecipeCompletedEvent((Object)this, result);
            if (context != null) {
                completedEvent.setBuildVersion(context.getBuildVersion());
            }
            this.eventManager.publish(completedEvent);
            this.runningLock.lock();
            this.runningRecipe = 0L;
            this.runningCommand = null;
            if (this.terminating) {
                this.terminating = false;
            }
            this.runningLock.unlock();
            throw throwable;
        }
    }

    private void writeTestResults(RecipePaths paths, TestSuiteResult testResults) {
        try {
            TestSuitePersister persister = new TestSuitePersister();
            File testDir = new File(paths.getOutputDir(), "tests");
            FileSystemUtils.createDirectory(testDir);
            persister.write(testResults, testDir);
        }
        catch (IOException e) {
            LOG.severe("Unable to write out test results", e);
        }
    }

    public void build(long recipeId, Scope globalScope, long recipeStartTime, Recipe recipe, RecipePaths paths, TestSuiteResult testResults, boolean capture, BuildContext context) throws BuildException {
        int i = 1;
        for (Command command : recipe.getCommands()) {
            File commandOutput;
            CommandResult result = new CommandResult(command.getName());
            if (!this.executeCommand(recipeId, globalScope, recipeStartTime, result, paths, commandOutput = new File(paths.getOutputDir(), RecipeProcessor.getCommandDirName(i, result)), testResults, command, capture, context)) {
                return;
            }
            switch (result.getState()) {
                case FAILURE: 
                case ERROR: {
                    return;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCommand(long recipeId, Scope globalScope, long recipeStartTime, CommandResult result, RecipePaths paths, File commandOutput, TestSuiteResult testResults, Command command, boolean capture, BuildContext context) {
        this.runningLock.lock();
        if (this.terminating) {
            this.runningLock.unlock();
            return false;
        }
        this.runningCommand = command;
        this.runningLock.unlock();
        result.commence();
        result.setOutputDir(commandOutput.getPath());
        this.eventManager.publish(new CommandCommencedEvent(this, recipeId, result.getCommandName(), result.getStamps().getStartTime()));
        CommandOutputStream outputStream = null;
        try {
            if (!commandOutput.mkdirs()) {
                throw new BuildException("Could not create command output directory '" + commandOutput.getAbsolutePath() + "'");
            }
            CommandContext commandContext = new CommandContext(paths, commandOutput, testResults);
            commandContext.setGlobalScope(globalScope);
            commandContext.setRecipeStartTime(recipeStartTime);
            if (context != null && context.getBuildNumber() != -1L) {
                commandContext.setBuildContext(context);
            }
            if (capture) {
                outputStream = new CommandOutputStream(this.eventManager, recipeId, true);
                commandContext.setOutputStream(outputStream);
            }
            command.execute(commandContext, result);
        }
        catch (BuildException e) {
            result.error(e);
        }
        catch (Exception e) {
            LOG.severe(e);
            result.error(new BuildException("Unexpected error: " + e.getMessage(), e));
        }
        finally {
            IOUtils.close(outputStream);
            result.complete();
            this.eventManager.publish(new CommandCompletedEvent(this, recipeId, result));
        }
        return true;
    }

    private PulseFile loadPulseFile(RecipeRequest request, File baseDir, ResourceRepository resourceRepository, Scope globalScope, BuildContext buildContext, long recipeStartTime) throws BuildException {
        PulseFile pulseFile;
        globalScope.add(new Property("base.dir", baseDir.getAbsolutePath()));
        globalScope.add(new Property("recipe.timestamp", BuildContext.PULSE_BUILD_TIMESTAMP_FORMAT.format(new Date(recipeStartTime))));
        globalScope.add(new Property("recipe.timestamp.millis", Long.toString(recipeStartTime)));
        if (buildContext != null) {
            globalScope.add(new Property("build.number", Long.toString(buildContext.getBuildNumber())));
            globalScope.add(new Property("build.revision", buildContext.getBuildRevision()));
            globalScope.add(new Property("build.timestamp", BuildContext.PULSE_BUILD_TIMESTAMP_FORMAT.format(new Date(buildContext.getBuildTimestamp()))));
            globalScope.add(new Property("build.timestamp.millis", Long.toString(buildContext.getBuildTimestamp())));
        }
        this.addEnvironment(globalScope);
        if (request.getProperties() != null) {
            globalScope.add((Collection<ResourceProperty>)request.getProperties());
        }
        this.importResources(resourceRepository, request.getResourceRequirements(), globalScope);
        ByteArrayInputStream stream = null;
        try {
            String pulseFileSource = request.getPulseFileSource();
            if (pulseFileSource.trim().length() == 0) {
                throw new ParseException("File is empty");
            }
            stream = new ByteArrayInputStream(pulseFileSource.getBytes());
            PulseFile result = new PulseFile();
            this.fileLoader.load(stream, result, globalScope, resourceRepository, new RecipeLoadPredicate(result, request.getRecipeName()));
            pulseFile = result;
        }
        catch (Exception e) {
            try {
                throw new BuildException("Unable to parse pulse file: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.close(stream);
                throw throwable;
            }
        }
        IOUtils.close(stream);
        return pulseFile;
    }

    private void addEnvironment(Scope globalScope) {
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> var : env.entrySet()) {
            globalScope.addEnvironmentProperty(var.getKey(), var.getValue());
        }
    }

    private void importResources(ResourceRepository resourceRepository, List<ResourceRequirement> resourceRequirements, Scope scope) {
        if (resourceRequirements != null) {
            for (ResourceRequirement requirement : resourceRequirements) {
                Resource resource = resourceRepository.getResource(requirement.getResource());
                if (resource == null) {
                    throw new BuildException("Unable to import required resource '" + requirement.getResource() + "'");
                }
                scope.add(resource.getProperties().values());
                String importVersion = requirement.getVersion();
                if (importVersion == null) {
                    importVersion = resource.getDefaultVersion();
                }
                if (!TextUtils.stringSet((String)importVersion)) continue;
                ResourceVersion version = resource.getVersion(importVersion);
                if (version == null) {
                    throw new BuildException("Reference to non-existant version '" + importVersion + "' of resource '" + requirement.getResource() + "'");
                }
                scope.add(version.getProperties().values());
            }
        }
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public FileLoader getFileLoader() {
        return this.fileLoader;
    }

    public void setFileLoader(FileLoader fileLoader) {
        this.fileLoader = fileLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateRecipe(long id) throws InterruptedException {
        this.runningLock.lock();
        try {
            if (this.runningRecipe == id) {
                this.terminating = true;
                if (this.runningCommand != null) {
                    this.runningCommand.terminate();
                }
            }
        }
        finally {
            this.runningLock.unlock();
        }
    }

    public long getBuildingRecipe() {
        return this.runningRecipe;
    }
}

