/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.Dependency;
import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.Recipe;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.ScopeAware;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PulseFile
implements ScopeAware {
    private String defaultRecipe;
    private String name;
    private List<Recipe> recipes = new LinkedList<Recipe>();
    private List<Dependency> dependencies = new LinkedList<Dependency>();
    private Scope globalScope;

    public String getDefaultRecipe() {
        return this.defaultRecipe;
    }

    public void setDefaultRecipe(String defaultRecipe) {
        this.defaultRecipe = defaultRecipe;
    }

    public Scope getGlobalScope() {
        return this.globalScope;
    }

    public void addRecipe(Recipe r) throws FileLoadException {
        if (this.getRecipe(r.getName()) != null) {
            throw new FileLoadException("A recipe with name '" + r.getName() + "' already exists");
        }
        this.recipes.add(r);
    }

    public List<Recipe> getRecipes() {
        return Collections.unmodifiableList(this.recipes);
    }

    public Recipe getRecipe(String name) {
        if (name == null) {
            return null;
        }
        for (Recipe recipe : this.recipes) {
            if (!name.equals(recipe.getName())) continue;
            return recipe;
        }
        return null;
    }

    public List<Dependency> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setScope(Scope scope) {
        this.globalScope = scope;
    }
}

