/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.PostProcessor;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredFileArtifact;
import java.util.LinkedList;
import java.util.List;

public class PostProcessorGroup
implements PostProcessor {
    private String name;
    private List<PostProcessor> processors = new LinkedList<PostProcessor>();

    public void process(StoredFileArtifact artifact, CommandResult result, CommandContext context) {
        for (PostProcessor processor : this.processors) {
            processor.process(artifact, result, context);
        }
    }

    public void add(PostProcessor processor) {
        this.processors.add(processor);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int size() {
        return this.processors.size();
    }

    public PostProcessor get(int index) {
        return this.processors.get(index);
    }
}

