/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.BuildContext;
import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Text;

public class MavenUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void extractVersion(CommandContext context, CommandResult result, File pom, String versionElementName) {
        BuildContext buildContext = context.getBuildContext();
        if (buildContext != null) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(pom);
                Builder builder = new Builder();
                Document doc = builder.build((InputStream)input);
                Elements elements = doc.getRootElement().getChildElements();
                for (int i = 0; i < elements.size(); ++i) {
                    Node child;
                    Element element = elements.get(i);
                    if (!element.getLocalName().equals(versionElementName) || element.getChildCount() <= 0 || (child = element.getChild(0)) == null || !(child instanceof Text)) continue;
                    buildContext.setBuildVersion(child.getValue().trim());
                    break;
                }
            }
            catch (ParsingException pex) {
                String message = "Unable to parse extract Maven POM file '" + pom.getAbsolutePath() + "' to extract version";
                if (pex.getMessage() != null) {
                    message = message + ": " + pex.getMessage();
                }
                result.warning(message);
                IOUtils.close(input);
            }
            catch (IOException e) {
                String message = "I/O error extracting version from Maven POM file '" + pom.getAbsolutePath() + "'";
                if (e.getMessage() != null) {
                    message = message + ": " + e.getMessage();
                }
                result.warning(message);
                {
                    catch (Throwable throwable) {
                        IOUtils.close(input);
                        throw throwable;
                    }
                }
                IOUtils.close(input);
            }
            IOUtils.close(input);
        }
    }
}

