/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.JUnitSummaryPostProcessor;
import com.zutubi.pulse.core.PostProcessorGroup;
import com.zutubi.pulse.core.RegexPattern;
import com.zutubi.pulse.core.RegexPostProcessor;
import com.zutubi.pulse.core.model.Feature;
import com.zutubi.pulse.util.SystemUtils;
import java.util.regex.Pattern;

public class Maven2PostProcessor
extends PostProcessorGroup {
    private static final String[] warningRegexps = new String[]{"^\\[WARNING\\]"};
    private RegexPostProcessor failurePP;
    private RegexPostProcessor featurePP;

    public Maven2PostProcessor() {
        this(null);
    }

    public Maven2PostProcessor(String name) {
        this.setName(name);
        this.add(new JUnitSummaryPostProcessor());
        Pattern failurePattern = Pattern.compile("^\\[ERROR\\] BUILD (ERROR|FAILURE)");
        this.featurePP = new RegexPostProcessor();
        RegexPattern errorRegex = new RegexPattern(Feature.Level.ERROR, Pattern.compile("^\\[ERROR\\]"));
        errorRegex.addExclusion(failurePattern);
        this.featurePP.addRegexPattern(errorRegex);
        this.featurePP.addWarningRegexs(warningRegexps);
        this.featurePP.setFailOnError(false);
        this.featurePP.setLeadingContext(1);
        this.featurePP.setTrailingContext(1);
        this.add(this.featurePP);
        this.failurePP = new RegexPostProcessor();
        RegexPattern failureRegex = new RegexPattern(Feature.Level.ERROR, failurePattern);
        this.failurePP.addRegexPattern(failureRegex);
        if (!SystemUtils.IS_WINDOWS) {
            this.failurePP.setFailOnError(false);
        }
        this.failurePP.setLeadingContext(1);
        this.failurePP.setTrailingContext(6);
        this.add(this.failurePP);
    }

    public void setFailOnError(boolean fail) {
        this.featurePP.setFailOnError(fail);
        this.failurePP.setFailOnError(fail);
    }

    public void setFailOnWarning(boolean fail) {
        this.featurePP.setFailOnWarning(fail);
        this.failurePP.setFailOnWarning(fail);
    }

    public void setLeadingContext(int lines) {
        this.featurePP.setLeadingContext(lines);
        this.failurePP.setLeadingContext(lines);
    }

    public void setTrailingContext(int lines) {
        this.featurePP.setTrailingContext(lines);
        this.failurePP.setTrailingContext(lines);
    }
}

