/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.ParseException;
import com.zutubi.pulse.core.Reference;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.UnknownAttributeException;
import com.zutubi.pulse.core.VariableHelper;
import com.zutubi.pulse.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectionHelper {
    private static final Hashtable<Class, Class> PRIMITIVE_TYPE_MAP = new Hashtable(8);
    private final Class bean;
    private Method setText;
    private final Map<String, NestedCreator> nestedCreators = new HashMap<String, NestedCreator>();
    private final Map<String, NestedAdder> nestedAdders = new HashMap<String, NestedAdder>();
    private final Map<String, AttributeSetter> attributeSetters = new HashMap<String, AttributeSetter>();
    private final Map<Class, NestedAdder> nestedTypeAdders = new HashMap<Class, NestedAdder>();
    private static final Map<Class, IntrospectionHelper> helpers;

    public static IntrospectionHelper getHelper(Class type, Map<String, Class> typeDefinitions) {
        if (!helpers.containsKey(type)) {
            helpers.put(type, new IntrospectionHelper(type, typeDefinitions));
        }
        return helpers.get(type);
    }

    private IntrospectionHelper(Class bean, Map<String, Class> typeDefinitions) {
        Method[] methods;
        this.bean = bean;
        for (final Method method : methods = this.bean.getMethods()) {
            String attribName;
            String name = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            if (name.equals("setText") && Void.TYPE.equals(returnType) && paramTypes.length == 1 && String.class.equals(paramTypes[0])) {
                this.setText = method;
                continue;
            }
            if (name.startsWith("set") && Void.TYPE.equals(returnType) && paramTypes.length == 1) {
                attribName = this.getPropertyName(name, "set");
                AttributeSetter setter = this.createAttributeSetter(method, paramTypes[0], typeDefinitions);
                if (setter == null) continue;
                this.attributeSetters.put(attribName, setter);
                continue;
            }
            if (name.startsWith("create") && paramTypes.length == 0 && !Void.TYPE.equals(returnType)) {
                attribName = this.getPropertyName(name, "create");
                this.nestedCreators.put(attribName, new NestedCreator(){

                    public Object create(Object parent) throws InvocationTargetException, IllegalAccessException {
                        return method.invoke(parent, new Object[0]);
                    }
                });
                continue;
            }
            if (!name.startsWith("add") || paramTypes.length != 1 || !Void.TYPE.equals(returnType)) continue;
            if (name.equals("add")) {
                NestedAdder adder = new NestedAdder(){

                    public void add(Object parent, Object arg) throws InvocationTargetException, IllegalAccessException {
                        method.invoke(parent, arg);
                    }
                };
                this.nestedTypeAdders.put(paramTypes[0], adder);
                continue;
            }
            String attributeName = this.getPropertyName(name, "add");
            this.nestedAdders.put(attributeName, new NestedAdder(){

                public void add(Object parent, Object arg) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(parent, arg);
                }
            });
        }
    }

    public boolean hasSetText() {
        return this.setText != null;
    }

    private String getPropertyName(String methodName, String prefix) {
        return methodName.substring(prefix.length(), prefix.length() + 1).toLowerCase() + methodName.substring(prefix.length() + 1);
    }

    private AttributeSetter createAttributeSetter(final Method method, Class arg, final Map<String, Class> typeDefinitions) {
        Class reflectedArg;
        Class clazz = reflectedArg = PRIMITIVE_TYPE_MAP.containsKey(arg) ? PRIMITIVE_TYPE_MAP.get(arg) : arg;
        if (String.class.equals((Object)reflectedArg)) {
            return new AttributeSetter(){

                public void set(Object parent, String value, boolean resolveReferences, Scope scope) throws InvocationTargetException, IllegalAccessException, FileLoadException {
                    method.invoke(parent, resolveReferences ? VariableHelper.replaceVariables(value, scope) : value);
                }
            };
        }
        if (Boolean.class.equals((Object)reflectedArg)) {
            return new AttributeSetter(){

                public void set(Object parent, String value, boolean resolveReferences, Scope scope) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(parent, IntrospectionHelper.toBoolean(value));
                }
            };
        }
        if (Character.class.equals((Object)reflectedArg)) {
            return new AttributeSetter(){

                public void set(Object parent, String value, boolean resolveReferences, Scope scope) throws InvocationTargetException, IllegalAccessException {
                    if (value.length() == 0) {
                        throw new RuntimeException();
                    }
                    method.invoke(parent, Character.valueOf(value.charAt(0)));
                }
            };
        }
        if (Class.class.equals((Object)reflectedArg)) {
            return new AttributeSetter(){

                public void set(Object parent, String value, boolean resolveReferences, Scope scope) throws InvocationTargetException, IllegalAccessException {
                    try {
                        method.invoke(parent, Class.forName(value));
                    }
                    catch (ClassNotFoundException ce) {
                        throw new InvocationTargetException(ce);
                    }
                }
            };
        }
        if (Reference.class.isAssignableFrom(reflectedArg)) {
            return new AttributeSetter(){

                @Override
                public void set(Object parent, String value, boolean resolveReferences, Scope scope) throws InvocationTargetException, IllegalAccessException, FileLoadException {
                    Object obj = VariableHelper.replaceVariable(value, scope);
                    if (!reflectedArg.isAssignableFrom(obj.getClass())) {
                        List<String> expectedTypes = this.getAssignablesForType(typeDefinitions, reflectedArg);
                        String gotType = this.getNameForType(typeDefinitions, obj.getClass());
                        throw new FileLoadException("Referenced property '" + value + "' has unexpected type (expected one of " + expectedTypes + ", got " + gotType + ").");
                    }
                    method.invoke(parent, obj);
                }

                private List<String> getAssignablesForType(Map<String, Class> typeDefinitions2, Class clazz) {
                    LinkedList<String> result = new LinkedList<String>();
                    for (Map.Entry<String, Class> e : typeDefinitions2.entrySet()) {
                        if (!clazz.isAssignableFrom(e.getValue())) continue;
                        result.add(e.getKey());
                    }
                    return result;
                }

                private String getNameForType(Map<String, Class> typeDefinitions2, Class clazz) {
                    for (Map.Entry<String, Class> e : typeDefinitions2.entrySet()) {
                        if (e.getValue() != clazz) continue;
                        return e.getKey();
                    }
                    return "<unknown>";
                }
            };
        }
        if (List.class.equals((Object)reflectedArg)) {
            return new AttributeSetter(){

                public void set(Object parent, String value, boolean resolveReferences, Scope scope) throws InvocationTargetException, IllegalAccessException, FileLoadException {
                    method.invoke(parent, resolveReferences ? VariableHelper.splitAndReplaceVariables(value, scope, false) : StringUtils.split(value));
                }
            };
        }
        try {
            final Constructor c = reflectedArg.getConstructor(String.class);
            return new AttributeSetter(){

                public void set(Object parent, String value, boolean resolveReferences, Scope scope) throws InvocationTargetException, IllegalAccessException, FileLoadException {
                    try {
                        Object attribute = c.newInstance(resolveReferences ? VariableHelper.replaceVariables(value, scope) : value);
                        method.invoke(parent, attribute);
                    }
                    catch (InstantiationException ie) {
                        throw new InvocationTargetException(ie);
                    }
                }
            };
        }
        catch (NoSuchMethodException nme) {
            return null;
        }
    }

    public boolean hasCreate(String name) {
        return this.nestedCreators.containsKey(name);
    }

    public boolean hasAdd(String name) {
        return this.nestedAdders.containsKey(name);
    }

    public boolean canAdd(Class type) {
        return this.getTypeAdders(type).size() > 0;
    }

    private List<NestedAdder> getTypeAdders(Class type) {
        LinkedList<NestedAdder> availableAdders = new LinkedList<NestedAdder>();
        for (Class c : this.nestedTypeAdders.keySet()) {
            if (!c.isAssignableFrom(type)) continue;
            availableAdders.add(this.nestedTypeAdders.get(c));
        }
        return availableAdders;
    }

    public boolean hasSetter(String name) {
        return this.attributeSetters.containsKey(name);
    }

    public Object create(String name, Object parent) throws IllegalAccessException, InvocationTargetException {
        return this.nestedCreators.get(name).create(parent);
    }

    public void set(String name, Object parent, String value, boolean resolveReferences, Scope scope) throws IllegalAccessException, InvocationTargetException, ParseException, FileLoadException {
        AttributeSetter setter = this.attributeSetters.get(name);
        if (setter == null) {
            throw new UnknownAttributeException("Unrecognised attribute '" + name + "'.");
        }
        this.attributeSetters.get(name).set(parent, value, resolveReferences, scope);
    }

    public void add(String name, Object parent, Object arg) throws IllegalAccessException, InvocationTargetException {
        this.nestedAdders.get(name).add(parent, arg);
    }

    public void add(Object parent, Object arg) throws IllegalAccessException, InvocationTargetException {
        List<NestedAdder> adders = this.getTypeAdders(arg.getClass());
        for (NestedAdder adder : adders) {
            adder.add(parent, arg);
        }
    }

    public void setText(Object parent, String txt) throws IllegalAccessException, InvocationTargetException {
        this.setText.invoke(parent, txt);
    }

    public static boolean toBoolean(String str) {
        return str.equalsIgnoreCase("on") || str.equalsIgnoreCase("true") || str.equalsIgnoreCase("yes");
    }

    static {
        Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        Class[] wrappers = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
        for (int i = 0; i < primitives.length; ++i) {
            PRIMITIVE_TYPE_MAP.put(primitives[i], wrappers[i]);
        }
        helpers = new HashMap<Class, IntrospectionHelper>();
    }

    private static interface NestedAdder {
        public void add(Object var1, Object var2) throws InvocationTargetException, IllegalAccessException;
    }

    private static interface AttributeSetter {
        public void set(Object var1, String var2, boolean var3, Scope var4) throws InvocationTargetException, IllegalAccessException, FileLoadException;
    }

    private static interface NestedCreator {
        public Object create(Object var1) throws InvocationTargetException, IllegalAccessException;
    }
}

