/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.PulseException;
import com.zutubi.pulse.core.ResourceFileLoader;
import com.zutubi.pulse.core.ResourceRepository;
import com.zutubi.pulse.core.model.Resource;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResourceRepository
implements ResourceRepository {
    private static final Logger LOG = Logger.getLogger(FileResourceRepository.class);
    private Map<String, Resource> resources = new TreeMap<String, Resource>();
    private File resourceDef;

    public void addResource(Resource r) {
        this.resources.put(r.getName(), r);
    }

    @Override
    public boolean hasResource(String name, String version) {
        Resource r = this.getResource(name);
        return r != null && (version == null || r.hasVersion(version));
    }

    @Override
    public boolean hasResource(String name) {
        return this.resources.containsKey(name);
    }

    @Override
    public Resource getResource(String name) {
        return this.resources.get(name);
    }

    @Override
    public List<String> getResourceNames() {
        return new LinkedList<String>(this.resources.keySet());
    }

    public void initialise() {
        try {
            this.refresh();
        }
        catch (Exception e) {
            LOG.warning(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void refresh() throws IllegalAccessException, IOException, PulseException, InvocationTargetException {
        if (this.resourceDef.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(this.resourceDef);
                ResourceFileLoader.load(input, this);
            }
            catch (FileNotFoundException fileNotFoundException) {
                IOUtils.close(input);
                catch (Throwable throwable) {
                    IOUtils.close(input);
                    throw throwable;
                }
            }
            IOUtils.close(input);
        }
    }

    public void setUserConfigRoot(File userConfigRoot) {
        this.resourceDef = new File(userConfigRoot, "resources.xml");
    }
}

