/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.FileResourceRepository;
import com.zutubi.pulse.core.InitComponent;
import com.zutubi.pulse.core.IntrospectionHelper;
import com.zutubi.pulse.core.LocationAwareElement;
import com.zutubi.pulse.core.LocationAwareNodeFactory;
import com.zutubi.pulse.core.Macro;
import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.core.ParseException;
import com.zutubi.pulse.core.PulseException;
import com.zutubi.pulse.core.Reference;
import com.zutubi.pulse.core.ResourceAware;
import com.zutubi.pulse.core.ResourceRepository;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.ScopeAware;
import com.zutubi.pulse.core.TypeLoadPredicate;
import com.zutubi.pulse.core.UnknownAttributeException;
import com.zutubi.pulse.core.VariableHelper;
import com.zutubi.pulse.core.validation.CommandValidationException;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.validation.MessagesTextProvider;
import com.zutubi.pulse.validation.PulseValidationContext;
import com.zutubi.pulse.validation.PulseValidationManager;
import com.zutubi.validation.ValidationException;
import com.zutubi.validation.ValidationManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.ParsingException;
import nu.xom.Text;

public class FileLoader {
    private static final int MAX_RECURSION_DEPTH = 128;
    private final Map<String, Class> typeDefinitions = new HashMap<String, Class>();
    private ObjectFactory factory;
    private ValidationManager validationManager;

    public void setValidationManager(ValidationManager validationManager) {
        this.validationManager = validationManager;
    }

    public void setObjectFactory(ObjectFactory factory) {
        this.factory = factory;
    }

    public void load(File file, Object root) throws PulseException, IOException, IllegalAccessException, InvocationTargetException {
        this.load(new FileInputStream(file), root);
    }

    public void load(InputStream input, Object root) throws PulseException {
        this.load(input, root, null, new FileResourceRepository(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream input, Object root, Scope globalScope, ResourceRepository resourceRepository, TypeLoadPredicate predicate) throws PulseException {
        try {
            Document doc;
            Builder builder = new Builder((NodeFactory)new LocationAwareNodeFactory());
            try {
                doc = builder.build(input);
            }
            catch (ParsingException pex) {
                throw new ParseException(pex.getLineNumber(), pex.getColumnNumber(), pex);
            }
            catch (IOException e) {
                throw new ParseException(e);
            }
            if (globalScope == null) {
                globalScope = new Scope();
            }
            Element rootElement = doc.getRootElement();
            if (ScopeAware.class.isAssignableFrom(root.getClass())) {
                ((ScopeAware)root).setScope(globalScope);
            }
            this.mapAttributesToProperties(rootElement, root, true, globalScope);
            for (int index = 0; index < rootElement.getChildCount(); ++index) {
                Node node = rootElement.getChild(index);
                if (!(node instanceof Element)) continue;
                this.loadType((Element)node, root, true, globalScope, 1, resourceRepository, predicate);
            }
        }
        finally {
            IOUtils.close(input);
        }
    }

    private void loadType(Element e, Object parent, boolean resolveReferences, Scope scope, int depth, ResourceRepository resourceRepository, TypeLoadPredicate predicate) throws PulseException {
        IntrospectionHelper parentHelper = IntrospectionHelper.getHelper(parent.getClass(), this.typeDefinitions);
        String name = e.getLocalName();
        try {
            boolean loadType;
            String referenceName;
            if (depth > 128) {
                throw new FileLoadException("Maximum recursion depth exceeded");
            }
            if (this.handleInternalElement(e, parent, resolveReferences, scope, parentHelper, depth, resourceRepository, predicate)) {
                return;
            }
            String propertyName = this.convertLocalNameToPropertyName(name);
            Object type = parentHelper.hasCreate(propertyName) ? parentHelper.create(propertyName, parent) : this.create(name);
            if (predicate != null) {
                resolveReferences = resolveReferences && predicate.resolveReferences(type, e);
            }
            IntrospectionHelper typeHelper = IntrospectionHelper.getHelper(type.getClass(), this.typeDefinitions);
            this.mapAttributesToProperties(e, type, resolveReferences, scope);
            if (Reference.class.isAssignableFrom(type.getClass()) && (referenceName = ((Reference)type).getName()) != null && referenceName.length() > 0) {
                scope.setReference((Reference)type);
            }
            boolean bl = loadType = predicate == null || predicate.loadType(type, e);
            if (loadType) {
                scope = new Scope(scope);
                if (ScopeAware.class.isAssignableFrom(type.getClass())) {
                    ((ScopeAware)type).setScope(scope);
                }
                if (ResourceAware.class.isAssignableFrom(type.getClass())) {
                    ((ResourceAware)type).setResourceRepository(resourceRepository);
                }
                if (InitComponent.class.isAssignableFrom(type.getClass())) {
                    ((InitComponent)type).initBeforeChildren();
                }
                this.loadSubElements(e, type, resolveReferences, scope, typeHelper, depth, resourceRepository, predicate);
            }
            if (parentHelper.hasAdd(propertyName)) {
                parentHelper.add(propertyName, parent, type);
            } else if (parentHelper.canAdd(type.getClass())) {
                parentHelper.add(parent, type);
            }
            if (loadType) {
                if (InitComponent.class.isAssignableFrom(type.getClass())) {
                    ((InitComponent)type).initAfterChildren();
                }
                this.validate(type);
            }
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getCause() != null ? ex.getCause() : ex;
            throw this.createParseException(name, e, t);
        }
        catch (ParseException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw this.createParseException(name, e, ex);
        }
    }

    private void validate(Object obj) throws CommandValidationException, ValidationException {
        this.validationManager = new PulseValidationManager();
        PulseValidationContext validationContext = new PulseValidationContext(new MessagesTextProvider(obj));
        this.validationManager.validate(obj, validationContext);
        if (validationContext.hasErrors()) {
            throw new CommandValidationException(validationContext);
        }
    }

    private void loadSubElements(Element e, Object type, boolean resolveReferences, Scope scope, IntrospectionHelper typeHelper, int depth, ResourceRepository resourceRepository, TypeLoadPredicate predicate) throws Exception {
        String text = null;
        for (int index = 0; index < e.getChildCount(); ++index) {
            Node node = e.getChild(index);
            if (node instanceof Element) {
                Element element = (Element)node;
                this.loadType(element, type, resolveReferences, scope, depth + 1, resourceRepository, predicate);
                continue;
            }
            if (!(node instanceof Text)) continue;
            text = text == null ? node.getValue() : text + node.getValue();
        }
        if (text != null && typeHelper.hasSetText()) {
            if (resolveReferences) {
                text = VariableHelper.replaceVariables(text, scope);
            }
            typeHelper.setText(type, text);
        }
    }

    private boolean handleInternalElement(Element element, Object type, boolean resolveReferences, Scope scope, IntrospectionHelper typeHelper, int depth, ResourceRepository resourceRepository, TypeLoadPredicate predicate) throws Exception {
        String localName = element.getLocalName();
        if (localName.equals("macro")) {
            boolean found = false;
            for (int i = 0; i < element.getAttributeCount(); ++i) {
                Attribute attribute = element.getAttribute(i);
                if (!attribute.getLocalName().equals("name")) {
                    throw new FileLoadException("Unrecognised attribute '" + attribute.getLocalName() + "'");
                }
                scope.setReference(new Macro(attribute.getValue(), element));
                found = true;
            }
            if (!found) {
                throw new FileLoadException("Required attribute 'name' not found");
            }
            return true;
        }
        if (localName.equals("macro-ref")) {
            boolean found = false;
            for (int i = 0; i < element.getAttributeCount(); ++i) {
                Attribute attribute = element.getAttribute(i);
                if (attribute.getLocalName().equals("macro")) {
                    String macroName = attribute.getValue();
                    Object o = VariableHelper.replaceVariable(macroName, scope);
                    if (!LocationAwareElement.class.isAssignableFrom(o.getClass())) {
                        throw new FileLoadException("Reference '" + macroName + "' does not resolve to a macro");
                    }
                    LocationAwareElement lae = (LocationAwareElement)((Object)o);
                    try {
                        this.loadSubElements(lae, type, resolveReferences, scope, typeHelper, depth, resourceRepository, predicate);
                    }
                    catch (Exception e) {
                        throw new FileLoadException("While expanding macro defined at line " + lae.getLineNumber() + " column " + lae.getColumnNumber() + ": " + e.getMessage(), e);
                    }
                } else {
                    throw new FileLoadException("Unrecognised attribute '" + attribute.getLocalName() + "'");
                }
                found = true;
            }
            if (!found) {
                throw new FileLoadException("Required attribute 'macro' not found");
            }
            return true;
        }
        if (localName.equals("scope")) {
            this.loadSubElements(element, type, resolveReferences, new Scope(scope), typeHelper, depth, resourceRepository, predicate);
            return true;
        }
        return false;
    }

    private ParseException createParseException(String name, Element element, Throwable t) {
        int line = -1;
        int column = -1;
        StringBuilder message = new StringBuilder(256);
        message.append("Processing element '");
        message.append(name);
        message.append("': ");
        if (element instanceof LocationAwareElement) {
            LocationAwareElement location = (LocationAwareElement)element;
            message.append("starting at line ");
            line = location.getLineNumber();
            message.append(line);
            message.append(" column ");
            column = location.getColumnNumber();
            message.append(column);
            message.append(": ");
        }
        message.append(t.getMessage());
        return new ParseException(line, column, message.toString());
    }

    private Object create(String name) throws FileLoadException {
        Class clz = this.typeDefinitions.get(name);
        if (clz != null) {
            try {
                return this.factory.buildBean(clz);
            }
            catch (Exception e) {
                throw new FileLoadException("Could not instantiate type '" + name + "'. Reason: " + e.getMessage());
            }
        }
        throw new FileLoadException("Undefined type '" + name + "'");
    }

    private String convertLocalNameToPropertyName(String name) {
        while (name.indexOf(45) != -1) {
            int index = name.indexOf(45);
            name = name.substring(0, index) + name.substring(index + 1, index + 2).toUpperCase() + name.substring(index + 2);
        }
        return name;
    }

    private void mapAttributesToProperties(Element source, Object target, boolean resolveReferences, Scope scope) throws FileLoadException {
        IntrospectionHelper helper = IntrospectionHelper.getHelper(target.getClass(), this.typeDefinitions);
        for (int i = 0; i < source.getAttributeCount(); ++i) {
            Attribute a = source.getAttribute(i);
            try {
                String propertyName = this.convertLocalNameToPropertyName(a.getLocalName());
                helper.set(propertyName, target, a.getValue(), resolveReferences, scope);
                continue;
            }
            catch (InvocationTargetException e) {
                throw new FileLoadException(e.getCause().getMessage());
            }
            catch (UnknownAttributeException e) {
                throw new FileLoadException("Unrecognised attribute '" + a.getLocalName() + "'.");
            }
            catch (Exception e) {
                throw new FileLoadException(e.getMessage());
            }
        }
    }

    public void register(String name, Class type) {
        this.typeDefinitions.put(name, type);
    }
}

