/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.LocalArtifact;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.util.FileSystemUtils;
import java.io.File;
import org.apache.tools.ant.DirectoryScanner;

public class FileArtifact
extends LocalArtifact {
    private String file;
    private String type = null;

    public void capture(CommandResult result, CommandContext context) {
        File captureFile = new File(this.file);
        if (captureFile.isAbsolute()) {
            if (captureFile.isFile()) {
                StoredArtifact artifact = new StoredArtifact(this.getName());
                if (this.captureFile(artifact, captureFile, FileSystemUtils.composeFilename(this.getName(), captureFile.getName()), result, context, this.type)) {
                    result.addArtifact(artifact);
                }
                return;
            }
            if (this.file.indexOf("*") != -1) {
                String filePath = captureFile.getAbsolutePath();
                File alternateBaseDir = new File(filePath.substring(0, filePath.indexOf(42)));
                if (!alternateBaseDir.isDirectory()) {
                    alternateBaseDir = alternateBaseDir.getParentFile();
                }
                if ((filePath = filePath.substring(alternateBaseDir.getAbsolutePath().length())).startsWith("/") || filePath.startsWith("\\")) {
                    filePath = filePath.substring(1);
                }
                this.scanAndCaptureFiles(alternateBaseDir, filePath, result, context);
            } else if (this.getFailIfNotPresent()) {
                throw new BuildException("Capturing artifact '" + this.getName() + "': no file matching '" + this.file + "' exists");
            }
        } else {
            this.scanAndCaptureFiles(context.getPaths().getBaseDir(), this.file, result, context);
        }
    }

    private void scanAndCaptureFiles(File baseDir, String file, CommandResult result, CommandContext context) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir);
        scanner.setIncludes(new String[]{file});
        scanner.scan();
        StoredArtifact artifact = new StoredArtifact(this.getName());
        for (String includedFile : scanner.getIncludedFiles()) {
            File source = new File(baseDir, includedFile);
            this.captureFile(artifact, source, FileSystemUtils.composeFilename(this.getName(), includedFile), result, context, this.type);
        }
        if (artifact.getChildren().size() > 0) {
            result.addArtifact(artifact);
        } else if (this.getFailIfNotPresent()) {
            throw new BuildException("Capturing artifact '" + this.getName() + "': no file matching '" + file + "' exists");
        }
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

