/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.LocalArtifact;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.util.FileSystemUtils;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryArtifact
extends LocalArtifact {
    private File base;
    private String index;
    private List<Pattern> inclusions;
    private List<Pattern> exclusions;
    private String type = null;

    public File getBase() {
        return this.base;
    }

    public void setBase(File base) {
        this.base = base;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public Pattern createInclude() {
        if (this.inclusions == null) {
            this.inclusions = new LinkedList<Pattern>();
        }
        Pattern result = new Pattern();
        this.inclusions.add(result);
        return result;
    }

    public Pattern createExclude() {
        if (this.exclusions == null) {
            this.exclusions = new LinkedList<Pattern>();
        }
        Pattern result = new Pattern();
        this.exclusions.add(result);
        return result;
    }

    @Override
    public void capture(CommandResult result, CommandContext context) {
        if (this.base == null) {
            this.base = context.getPaths().getBaseDir();
        } else if (!this.base.isAbsolute()) {
            this.base = new File(context.getPaths().getBaseDir(), this.base.getPath());
        }
        if (!this.base.exists()) {
            if (this.getFailIfNotPresent()) {
                throw new BuildException("Capturing artifact '" + this.getName() + "': base directory '" + this.base.getAbsolutePath() + "' does not exist");
            }
            return;
        }
        if (!this.base.isDirectory()) {
            throw new BuildException("Directory artifact '" + this.getName() + "': base '" + this.base.getAbsolutePath() + "' is not a directory");
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.base);
        if (this.inclusions != null) {
            scanner.setIncludes(this.flattenPatterns(this.inclusions));
        }
        if (this.exclusions != null) {
            scanner.setExcludes(this.flattenPatterns(this.exclusions));
        }
        scanner.scan();
        StoredArtifact artifact = new StoredArtifact(this.getName());
        artifact.setIndex(this.index);
        for (String file : scanner.getIncludedFiles()) {
            File source = new File(this.base, file);
            this.captureFile(artifact, source, FileSystemUtils.composeFilename(this.getName(), file), result, context, this.type);
        }
        result.addArtifact(artifact);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private String[] flattenPatterns(List<Pattern> patterns) {
        String[] result = new String[patterns.size()];
        int i = 0;
        for (Pattern p : patterns) {
            result[i++] = p.getPattern();
        }
        return result;
    }

    public class Pattern {
        private String pattern;

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }
}

