/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.events.build.CommandOutputEvent;
import java.io.OutputStream;

public class CommandOutputStream
extends OutputStream
implements Runnable {
    public static int MINIMUM_SIZE = 1024;
    private EventManager eventManager;
    private long recipeId;
    private byte[] buffer;
    private int offset;
    private Thread flusher;

    public CommandOutputStream(EventManager eventManager, long recipeId, boolean autoflush) {
        this.eventManager = eventManager;
        this.recipeId = recipeId;
        this.buffer = new byte[MINIMUM_SIZE];
        this.offset = 0;
        if (autoflush) {
            this.flusher = new Thread(this);
            this.flusher.start();
        }
    }

    public synchronized void write(int b) {
        this.buffer[this.offset++] = (byte)b;
        this.checkBuffer();
    }

    public synchronized void write(byte[] b, int off, int len) {
        if (this.offset + len <= MINIMUM_SIZE) {
            System.arraycopy(b, off, this.buffer, this.offset, len);
            this.offset += len;
            this.checkBuffer();
        } else {
            byte[] sendBuffer = new byte[this.offset + len];
            System.arraycopy(this.buffer, 0, sendBuffer, 0, this.offset);
            System.arraycopy(b, off, sendBuffer, this.offset, len);
            this.sendEvent(sendBuffer);
        }
    }

    public synchronized void flush() {
        if (this.offset > 0) {
            this.sendBuffer();
        }
    }

    public synchronized void close() {
        this.flush();
        this.buffer = null;
        this.offset = 0;
    }

    private synchronized void checkBuffer() {
        if (this.offset == MINIMUM_SIZE) {
            this.sendBuffer();
        }
    }

    private synchronized void sendBuffer() {
        byte[] sendBuffer = new byte[this.offset];
        System.arraycopy(this.buffer, 0, sendBuffer, 0, this.offset);
        this.sendEvent(sendBuffer);
    }

    private void sendEvent(byte[] sendBuffer) {
        CommandOutputEvent event = new CommandOutputEvent(this, this.recipeId, sendBuffer);
        this.eventManager.publish(event);
        this.offset = 0;
    }

    public void run() {
        while (this.buffer != null) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.flush();
        }
    }
}

