/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.core.Artifact;
import com.zutubi.pulse.core.Command;
import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.DirectoryArtifact;
import com.zutubi.pulse.core.FileArtifact;
import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.LinkArtifact;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.validation.Validateable;
import com.zutubi.validation.ValidationContext;
import com.zutubi.validation.annotations.Required;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandGroup
implements Command,
Validateable {
    private String name;
    private Command command = null;
    private List<Artifact> artifacts = new LinkedList<Artifact>();

    public void add(Command cmd) throws FileLoadException {
        if (this.command != null) {
            throw new FileLoadException("A 'command' tag may only contain a single nested command.");
        }
        this.command = cmd;
        if (!TextUtils.stringSet((String)this.command.getName())) {
            this.command.setName(this.name);
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void terminate() {
        this.command.terminate();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public FileArtifact createArtifact() {
        FileArtifact customArtifact = new FileArtifact();
        this.artifacts.add(customArtifact);
        return customArtifact;
    }

    public DirectoryArtifact createDirArtifact() {
        DirectoryArtifact customArtifact = new DirectoryArtifact();
        this.artifacts.add(customArtifact);
        return customArtifact;
    }

    public LinkArtifact createLinkArtifact() {
        LinkArtifact linkArtifact = new LinkArtifact();
        this.artifacts.add(linkArtifact);
        return linkArtifact;
    }

    @Override
    public void execute(CommandContext context, CommandResult result) {
        this.command.execute(context, result);
        for (Artifact artifact : this.artifacts) {
            artifact.capture(result, context);
        }
    }

    List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public List<String> getArtifactNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (Artifact artifact : this.artifacts) {
            names.add(artifact.getName());
        }
        names.addAll(this.getCommand().getArtifactNames());
        return names;
    }

    @Required
    public Command getCommand() {
        return this.command;
    }

    @Override
    public void validate(ValidationContext context) {
        List<String> artifactNames = this.getArtifactNames();
        TreeSet<String> names = new TreeSet<String>();
        for (String name : artifactNames) {
            if (names.contains(name)) {
                context.addFieldError("name", "A duplicate artifact name '" + name + "' has been detected. Please only " + "use unique names for artifacts within a command group.");
            }
            names.add(name);
        }
    }
}

