/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.RecipeRequest;
import com.zutubi.pulse.core.model.Revision;

public class BuildRevision {
    private Revision revision;
    private String pulseFile;
    private boolean fixed;
    private boolean user;
    private long timestamp = -1L;

    public BuildRevision() {
        this.fixed = false;
        this.user = false;
    }

    public BuildRevision(Revision revision, String pulseFile, boolean user) {
        assert (revision != null);
        this.revision = revision;
        this.pulseFile = pulseFile;
        this.fixed = true;
        this.user = user;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public String getPulseFile() {
        return this.pulseFile;
    }

    public boolean isInitialised() {
        return this.revision != null;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isUser() {
        return this.user;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void update(Revision revision, String pulseFile) {
        assert (!this.fixed);
        this.revision = revision;
        this.pulseFile = pulseFile;
    }

    public void apply(RecipeRequest request) {
        request.setPulseFileSource(this.pulseFile);
        this.fixed = true;
        if (this.timestamp < 0L) {
            this.timestamp = System.currentTimeMillis();
        }
    }
}

