/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.core;

import com.zutubi.pulse.core.AntPostProcessor;
import com.zutubi.pulse.core.CommandContext;
import com.zutubi.pulse.core.ExecutableCommand;
import com.zutubi.pulse.core.Reference;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.util.SystemUtils;

public class AntCommand
extends ExecutableCommand {
    private String buildFile;
    private String targets;

    private void checkExe() {
        if (this.getExe() == null) {
            Reference ref;
            Scope scope = this.getScope();
            if (scope != null && (ref = scope.getReference("ant.bin")) != null && ref.getValue() instanceof String) {
                this.setExe((String)ref.getValue());
            }
            if (this.getExe() == null) {
                if (SystemUtils.IS_WINDOWS) {
                    this.setExe("ant.bat");
                } else {
                    this.setExe("ant");
                }
            }
        }
    }

    public void execute(CommandContext context, CommandResult cmdResult) {
        this.checkExe();
        if (this.buildFile != null) {
            this.addArguments("-f", this.buildFile);
            cmdResult.getProperties().put("build file", this.buildFile);
        }
        if (this.targets != null) {
            this.addArguments(this.targets.split(" +"));
            cmdResult.getProperties().put("targets", this.targets);
        }
        super.execute(context, cmdResult);
        StoredArtifact artifact = cmdResult.getArtifact("command output");
        if (artifact != null) {
            AntPostProcessor pp = new AntPostProcessor("ant.pp");
            pp.process(artifact.getFile(), cmdResult, context);
        }
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public String getTargets() {
        return this.targets;
    }

    public void setTargets(String targets) {
        this.targets = targets;
    }

    public void setScope(Scope scope) {
        super.setScope(scope);
        this.checkExe();
    }
}

