/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.config;

import com.zutubi.pulse.util.Constants;
import com.zutubi.pulse.util.IOUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class PropertiesWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File config, Properties props) throws IOException {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)props);
        this.convert(copy);
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = null;
        try {
            String propertyName;
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(config)));
            while ((line = reader.readLine()) != null) {
                String trimmedLine = line.trim();
                if (trimmedLine.startsWith("#")) {
                    buffer.append(line);
                } else if (trimmedLine.length() == 0) {
                    buffer.append(line);
                } else {
                    boolean isMultiLine;
                    propertyName = trimmedLine.substring(0, trimmedLine.indexOf(61));
                    if (copy.containsKey(propertyName)) {
                        buffer.append(propertyName).append("=").append(copy.getProperty(propertyName));
                        copy.remove(propertyName);
                        isMultiLine = line.endsWith("\\");
                        while (isMultiLine && (line = reader.readLine()) != null) {
                            isMultiLine = line.endsWith("\\");
                        }
                    } else {
                        isMultiLine = line.endsWith("\\");
                        while (isMultiLine) {
                            buffer.append(line);
                            buffer.append(Constants.LINE_SEPARATOR);
                            line = reader.readLine();
                            if (line == null) break;
                            isMultiLine = line.endsWith("\\");
                        }
                        buffer.append(line);
                    }
                }
                buffer.append(Constants.LINE_SEPARATOR);
            }
            Enumeration<?> remainingNames = copy.propertyNames();
            while (remainingNames.hasMoreElements()) {
                propertyName = (String)remainingNames.nextElement();
                buffer.append(propertyName).append("=").append(copy.getProperty(propertyName));
                buffer.append(Constants.LINE_SEPARATOR);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close(reader);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(config)));
            writer.append(buffer.toString());
            writer.flush();
        }
        catch (Throwable throwable) {
            IOUtils.close(writer);
            throw throwable;
        }
        IOUtils.close(writer);
    }

    private void convert(Properties properties) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            properties.store(os, null);
            BufferedReader reader = new BufferedReader(new StringReader(os.toString()));
            String line = reader.readLine();
            while (line != null) {
                if (line.indexOf(61) != -1) {
                    String propertyName = line.substring(0, line.indexOf(61));
                    String value = line.substring(line.indexOf(61) + 1);
                    properties.setProperty(propertyName, value);
                }
                line = reader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

