/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.config;

import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.config.PropertiesWriter;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class FileConfig
implements Config {
    private static final Logger LOG = Logger.getLogger(FileConfig.class);
    private final File file;
    private Properties props;

    public FileConfig(File file) {
        this.file = file;
    }

    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.getProperties().setProperty(key, value);
        this.writeToFile();
    }

    private void writeToFile() {
        try {
            if (!this.file.isFile()) {
                if (!this.file.getParentFile().isDirectory() && !this.file.getParentFile().mkdirs()) {
                    throw new IOException();
                }
                if (!this.file.createNewFile()) {
                    throw new IOException();
                }
            }
            PropertiesWriter writer = new PropertiesWriter();
            writer.write(this.file, this.getProperties());
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public boolean hasProperty(String key) {
        return this.getProperties().containsKey(key);
    }

    public void removeProperty(String key) {
        this.getProperties().remove(key);
        this.writeToFile();
    }

    private Properties getProperties() {
        if (this.props == null) {
            try {
                this.props = this.file.isFile() ? IOUtils.read(this.file) : new Properties();
            }
            catch (IOException e) {
                LOG.severe(e);
                this.props = new Properties();
            }
        }
        return this.props;
    }

    public boolean isWriteable() {
        return true;
    }
}

