/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.config;

import com.zutubi.pulse.config.Config;

public class ConfigSupport
implements Config {
    protected Config config;

    public ConfigSupport(Config config) {
        this.config = config;
    }

    public String getProperty(String key) {
        return this.config.getProperty(key);
    }

    public boolean hasProperty(String key) {
        return this.config.hasProperty(key);
    }

    public void removeProperty(String key) {
        this.config.removeProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.hasProperty(key)) {
            return this.getProperty(key);
        }
        return defaultValue;
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this.config.setProperty(key, value);
        } else {
            this.config.removeProperty(key);
        }
    }

    public boolean isWriteable() {
        return this.config.isWriteable();
    }

    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        if (this.hasProperty(key)) {
            try {
                return Integer.valueOf(this.getProperty(key));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public void setInteger(String key, Integer value) {
        if (value != null) {
            this.setProperty(key, Integer.toString(value));
        } else {
            this.removeProperty(key);
        }
    }

    public Long getLong(String key) {
        if (this.hasProperty(key)) {
            return Long.valueOf(this.getProperty(key));
        }
        return null;
    }

    public Long getLong(String key, Long defaultValue) {
        if (this.hasProperty(key)) {
            try {
                return Long.valueOf(this.getProperty(key));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public void setLong(String key, Long value) {
        if (value != null) {
            this.setProperty(key, value.toString());
        } else {
            this.removeProperty(key);
        }
    }

    public Boolean getBooleanProperty(String key, Boolean defaultValue) {
        if (this.hasProperty(key)) {
            return Boolean.valueOf(this.getProperty(key));
        }
        return defaultValue;
    }

    public void setBooleanProperty(String key, Boolean val) {
        if (val != null) {
            this.setProperty(key, val.toString());
        } else {
            this.removeProperty(key);
        }
    }
}

