/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class Version
implements Comparable {
    private static final String RESOURCE = "version.properties";
    public static final String VERSION_NUMBER = "version.number";
    public static final String BUILD_DATE = "build.date";
    public static final String BUILD_NUMBER = "build.number";
    public static final String RELEASE_DATE = "release.date";
    public static final int INVALID = -1;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("d-MMMM-yyyy");
    private String versionNumber;
    private String buildDate;
    private String buildNumber;
    private String releaseDate;

    public Version() {
    }

    public Version(String versionNumber, String buildDate, String buildNumber, String releaseDate) {
        this.versionNumber = versionNumber;
        this.buildDate = buildDate;
        this.buildNumber = buildNumber;
        this.releaseDate = releaseDate;
        if (buildNumber.equals("010200000")) {
            buildNumber = "0102000000";
        }
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public Date getBuildDateAsDate() {
        try {
            return DATE_FORMAT.parse(this.getBuildDate());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public Date getReleaseDateAsDate() {
        try {
            return DATE_FORMAT.parse(this.getReleaseDate());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public int getBuildNumberAsInt() {
        try {
            return Integer.parseInt(this.buildNumber);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static Version load(InputStream in) throws IOException {
        Properties properties = IOUtils.read(in);
        return Version.read(properties);
    }

    public static Version read(Properties properties) {
        return new Version(properties.getProperty(VERSION_NUMBER), properties.getProperty(BUILD_DATE), properties.getProperty(BUILD_NUMBER), properties.getProperty(RELEASE_DATE));
    }

    public void write(OutputStream out) throws IOException {
        Properties props = new Properties();
        this.write(props);
        props.store(out, null);
    }

    public void write(Properties props) {
        props.setProperty(VERSION_NUMBER, this.getVersionNumber());
        props.setProperty(BUILD_DATE, this.getBuildDate());
        props.setProperty(BUILD_NUMBER, this.getBuildNumber());
        props.setProperty(RELEASE_DATE, this.getReleaseDate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File f) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            this.write(out);
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version load(File f) throws IOException {
        Version version;
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            version = Version.load(in);
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getVersion() {
        InputStream in = null;
        try {
            in = Version.class.getResourceAsStream(RESOURCE);
            Version version = Version.load(in);
            return version;
        }
        catch (IOException e) {
            Version version = new Version("N/A", "N/A", "N/A", "N/A");
            return version;
        }
        finally {
            IOUtils.close(in);
        }
    }

    public int compareTo(Object o) {
        Version otherVersion = (Version)o;
        Integer i = this.getBuildNumberAsInt();
        Integer j = otherVersion.getBuildNumberAsInt();
        return i.compareTo(j);
    }

    public static int getPatch(int buildNumber) {
        return buildNumber % 1000;
    }

    public static String buildNumberToVersion(int buildNumber) {
        int build = (buildNumber /= 1000) % 1000;
        int minor = (buildNumber /= 1000) % 100;
        int major = buildNumber / 100;
        return String.format("%d.%d.%d", major, minor, build);
    }
}

