/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.plugins.repositories;

import com.zutubi.plugins.ComponentDescriptorFactory;
import com.zutubi.plugins.Plugin;
import com.zutubi.plugins.PluginRepository;
import com.zutubi.plugins.internal.loaders.ArchivePluginLoader;
import com.zutubi.plugins.utils.FileOnlyFilter;
import com.zutubi.plugins.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalPluginRepository
implements PluginRepository {
    private File repositoryDirectory = null;
    private Map<String, Plugin> loadedPlugins = new HashMap<String, Plugin>();
    private ComponentDescriptorFactory descriptorFactory;
    private boolean scannedForPlugins = false;

    public LocalPluginRepository(File repositoryDirectory) {
        this.repositoryDirectory = repositoryDirectory;
    }

    public void setDescriptorFactory(ComponentDescriptorFactory descriptorFactory) {
        this.descriptorFactory = descriptorFactory;
    }

    public void scanForPlugins() {
        if (!this.scannedForPlugins) {
            for (File file : this.repositoryDirectory.listFiles(new FileOnlyFilter())) {
                this.loadPlugin(file);
            }
            this.scannedForPlugins = true;
        }
    }

    protected void loadPlugin(File f) {
        ArchivePluginLoader loader = new ArchivePluginLoader();
        loader.setComponentDescriptorFactory(this.descriptorFactory);
        loader.setArchive(f);
        for (Plugin plugin : loader.loadPlugins()) {
            if (this.containsPlugin(plugin)) {
                throw new IllegalStateException("plugin already loaded");
            }
            this.loadedPlugins.put(plugin.getKey(), plugin);
        }
    }

    protected void unloadPlugin(Plugin plugin) {
        if (!this.loadedPlugins.containsKey(plugin.getKey())) {
            throw new IllegalArgumentException();
        }
        this.loadedPlugins.remove(plugin.getKey());
        plugin.close();
    }

    @Override
    public List<String> listPlugins() {
        return new LinkedList<String>(this.loadedPlugins.keySet());
    }

    @Override
    public Plugin getPlugin(String key) {
        return this.loadedPlugins.get(key);
    }

    public List<Plugin> getPlugins() {
        return new LinkedList<Plugin>(this.loadedPlugins.values());
    }

    @Override
    public boolean containsPlugin(Plugin plugin) {
        return this.loadedPlugins.containsKey(plugin.getKey());
    }

    @Override
    public Plugin installPlugin(Plugin plugin) {
        try {
            URL source = plugin.getSource();
            String fileName = source.getPath();
            if (fileName.contains("/")) {
                fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
            }
            File repositoryPluginFile = new File(this.repositoryDirectory, fileName + "." + FileUtils.randomString(5));
            while (repositoryPluginFile.exists()) {
                repositoryPluginFile = new File(this.repositoryDirectory, fileName + "." + FileUtils.randomString(5));
            }
            FileUtils.copyAndClose(source.openStream(), new FileOutputStream(repositoryPluginFile));
            this.loadPlugin(repositoryPluginFile);
            return this.loadedPlugins.get(plugin.getKey());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void uninstallPlugin(Plugin plugin) {
        if (plugin.isEnabled()) {
            throw new IllegalArgumentException();
        }
        this.unloadPlugin(plugin);
        URL source = plugin.getSource();
        try {
            File installedPlugin = new File(source.toURI());
            if (!installedPlugin.delete()) {
                throw new RuntimeException();
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean supportsInstall() {
        return true;
    }

    @Override
    public boolean supportsUninstall() {
        return true;
    }

    @Override
    public void destory() {
        LinkedList<Plugin> plugins = new LinkedList<Plugin>(this.loadedPlugins.values());
        for (Plugin plugin : plugins) {
            this.unloadPlugin(plugin);
        }
    }
}

