/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.plugins.internal;

import com.zutubi.plugins.Plugin;
import com.zutubi.plugins.PluginLoader;
import com.zutubi.plugins.PluginManager;
import com.zutubi.plugins.PluginRepository;
import com.zutubi.plugins.internal.DefaultPlugin;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginManager
implements PluginManager {
    private List<DefaultPlugin> plugins = new LinkedList<DefaultPlugin>();
    private List<PluginLoader> loaders = new LinkedList<PluginLoader>();
    private PluginRepository pluginRepository = null;

    public void setPluginRepository(PluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    public void setPluginLoaders(List<PluginLoader> loaders) {
        this.loaders = loaders;
    }

    public void addPluginLoader(PluginLoader loader) {
        this.loaders.add(loader);
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public List<? extends Plugin> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }

    @Override
    public Plugin getPlugin(String key) {
        for (DefaultPlugin plugin : this.plugins) {
            if (!plugin.getKey().equals(key)) continue;
            return plugin;
        }
        return null;
    }

    @Override
    public void enable(Plugin plugin) {
        plugin.enable();
    }

    @Override
    public void disable(Plugin plugin) {
        plugin.disable();
    }

    @Override
    public void install(Plugin plugin) {
        this.pluginRepository.installPlugin(plugin);
    }

    @Override
    public void uninstall(Plugin plugin) {
        this.pluginRepository.uninstallPlugin(plugin);
    }
}

