/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.plugins.classloader;

import com.zutubi.plugins.classloader.DirectoryClassLoader;
import com.zutubi.plugins.classloader.JarClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluginsClassLoader
extends SecureClassLoader
implements Cloneable {
    protected String[] packages = null;
    private Map<String, Class> cache = new HashMap<String, Class>();

    protected PluginsClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.cache.get(name);
        if (c != null) {
            return c;
        }
        boolean handles = false;
        if (this.packages != null) {
            for (String pkg : this.packages) {
                if (!name.startsWith(pkg)) continue;
                handles = true;
                break;
            }
        }
        if (!handles) {
            return super.loadClass(name, resolve);
        }
        try {
            c = this.findClass(name);
            this.cache.put(name, c);
        }
        catch (ClassNotFoundException ex) {
            return super.loadClass(name, resolve);
        }
        return c;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        byte[] data = this.getFile(path);
        if (data == null) {
            throw new ClassNotFoundException();
        }
        return this.defineClass(name, data, 0, data.length);
    }

    @Override
    public URL findResource(String name) {
        byte[] data = this.getFile(name);
        if (data == null) {
            return null;
        }
        try {
            return this.getDataURL(name, data);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected abstract URL getDataURL(String var1, byte[] var2) throws MalformedURLException;

    @Override
    public Enumeration<URL> findResources(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            return null;
        }
        return Collections.enumeration(Collections.singleton(url));
    }

    protected abstract byte[] getFile(String var1);

    public static ClassLoader getInstance(URL url) {
        return PluginsClassLoader.getInstance(url, ClassLoader.getSystemClassLoader());
    }

    public static ClassLoader getInstance(URL url, ClassLoader parent) {
        File file;
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(url.toString());
        }
        PluginsClassLoader loader = file.isDirectory() ? new DirectoryClassLoader(file, parent) : new JarClassLoader(file, parent);
        return loader;
    }

    public abstract Object clone();

    public static byte[] readStream(InputStream in, int size) throws IOException {
        int bytesRead;
        if (in == null) {
            return null;
        }
        if (size == 0) {
            return new byte[0];
        }
        byte[] data = new byte[size];
        for (int currentTotal = 0; currentTotal < data.length && (bytesRead = in.read(data, currentTotal, data.length - currentTotal)) >= 0; currentTotal += bytesRead) {
        }
        return data;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url != null) {
            return url;
        }
        return super.getResource(name);
    }

    public void close() {
    }
}

