/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.plugins.classloader;

import com.zutubi.plugins.classloader.BytesURLStreamHandler;
import com.zutubi.plugins.classloader.PluginsClassLoader;
import com.zutubi.plugins.utils.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class DirectoryClassLoader
extends PluginsClassLoader {
    private File dir = null;

    public DirectoryClassLoader(File dir, ClassLoader parent) {
        super(parent);
        this.dir = dir;
    }

    protected URL getDataURL(String name, byte[] data) throws MalformedURLException {
        return new URL(null, this.dir.toURI().toURL().toExternalForm() + name, new BytesURLStreamHandler(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getFile(String path) {
        FileInputStream input = null;
        try {
            int n;
            File f = new File(this.dir, path);
            if (!f.isFile()) {
                byte[] byArray = null;
                return byArray;
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            input = new FileInputStream(f);
            byte[] buffer = new byte[1024];
            while ((n = ((InputStream)input).read(buffer)) > 0) {
                output.write(buffer, 0, n);
            }
            byte[] byArray = output.toByteArray();
            IOUtils.close(input);
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtils.close(input);
        }
    }

    public Object clone() {
        DirectoryClassLoader cl = new DirectoryClassLoader(this.dir, this.getParent());
        cl.packages = this.packages;
        return cl;
    }
}

