/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.i18n.error;

import com.zutubi.i18n.DefaultMessageHandler;
import com.zutubi.i18n.MessageHandler;
import com.zutubi.i18n.bundle.DefaultBundleManager;
import com.zutubi.i18n.context.DefaultContextCache;
import com.zutubi.i18n.context.IdContext;
import com.zutubi.i18n.context.IdContextResolver;
import com.zutubi.i18n.context.PackageContext;
import com.zutubi.i18n.context.StaticPackageContextResolver;
import com.zutubi.i18n.error.ErrorCode;
import java.text.MessageFormat;

public class ErrorHandler {
    private IdContext errorContext = new IdContext("error");
    private IdContextResolver idResolver = new IdContextResolver();
    private StaticPackageContextResolver packageResolver = new StaticPackageContextResolver();
    private MessageHandler handler;
    private String pattern = "{0}: {1}";

    public ErrorHandler() {
        DefaultBundleManager bundleManager = new DefaultBundleManager(new DefaultContextCache());
        bundleManager.addResolver(this.idResolver);
        bundleManager.addResolver(this.packageResolver);
        this.handler = new DefaultMessageHandler(bundleManager);
        this.setBundle("errors");
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String error(ErrorCode errorCode) {
        return MessageFormat.format(this.pattern, errorCode.getError(), this.handler.format(this.errorContext, errorCode.getError()));
    }

    public String error(ErrorCode errorCode, Object arg) {
        return MessageFormat.format(this.pattern, errorCode.getError(), this.handler.format((Object)this.errorContext, errorCode.getError(), arg));
    }

    public String error(ErrorCode errorCode, Object ... args) {
        return MessageFormat.format(this.pattern, errorCode.getError(), this.handler.format((Object)this.errorContext, errorCode.getError(), args));
    }

    public void setBundle(String bundleName) {
        this.idResolver.addBundle(this.errorContext, bundleName);
    }

    public void setBundle(String bundleName, String packageName) {
        this.packageResolver.addBundle(new PackageContext(packageName), bundleName);
    }
}

