/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.i18n.context;

import com.zutubi.i18n.context.Context;
import com.zutubi.i18n.context.ContextCache;
import com.zutubi.i18n.context.ContextKey;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.misc.SoftCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContextCache
implements ContextCache {
    private SoftCache contextCache;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final int INITIAL_CACHE_SIZE = 25;
    private static final float CACHE_LOAD_FACTOR = 1.0f;

    public DefaultContextCache() {
        this.contextCache = new SoftCache(25, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToCache(Context context, Locale locale, List<ResourceBundle> bundles) {
        try {
            this.lock.writeLock().lock();
            this.contextCache.put((Object)ContextKey.generate(context, locale), bundles);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResourceBundle> getFromCache(Context context, Locale locale) {
        try {
            this.lock.readLock().lock();
            List list = (List)this.contextCache.get((Object)ContextKey.generate(context, locale));
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCached(Context context, Locale locale) {
        try {
            this.lock.readLock().lock();
            boolean bl = this.contextCache.containsKey((Object)ContextKey.generate(context, locale));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            this.lock.writeLock().lock();
            try {
                this.lock.writeLock().lock();
                this.contextCache.clear();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

