/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.i18n.bundle;

import com.zutubi.i18n.bundle.BaseResourceBundleFactory;
import com.zutubi.i18n.bundle.BundleManager;
import com.zutubi.i18n.bundle.ResourceBundleFactory;
import com.zutubi.i18n.context.Context;
import com.zutubi.i18n.context.ContextCache;
import com.zutubi.i18n.context.ContextLoader;
import com.zutubi.i18n.context.ContextResolver;
import com.zutubi.i18n.context.DefaultContextLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBundleManager
implements BundleManager {
    private ResourceBundleFactory factory = new BaseResourceBundleFactory();
    private ContextCache cache;
    private Map<Class<? extends Context>, ContextResolver> resolvers = new HashMap<Class<? extends Context>, ContextResolver>();
    private ContextLoader defaultLoader = new DefaultContextLoader();

    public DefaultBundleManager() {
    }

    public DefaultBundleManager(ContextCache cache) {
        this.cache = cache;
    }

    public void addResolver(ContextResolver resolver) {
        this.resolvers.put(resolver.getContextType(), resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResourceBundle> getBundles(Object contextObject, Locale locale) {
        String[] bundleNames;
        Context context = (Context)contextObject;
        if (this.cache.isCached(context, locale)) {
            return this.cache.getFromCache(context, locale);
        }
        LinkedList<ResourceBundle> bundles = new LinkedList<ResourceBundle>();
        for (String bundleName : bundleNames = this.resolvers.get(context.getClass()).resolve(context)) {
            List<String> candidateNames = this.factory.expand(bundleName, locale);
            for (String candidateName : candidateNames) {
                InputStream input = null;
                try {
                    input = this.getContextLoader(context).loadResource(context, candidateName);
                    if (input == null) continue;
                    bundles.add(this.factory.loadBundle(input, locale));
                }
                catch (IOException e) {}
                continue;
                finally {
                    if (input == null) continue;
                    try {
                        input.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        this.cache.addToCache(context, locale, bundles);
        return bundles;
    }

    private ContextLoader getContextLoader(Context context) {
        return this.defaultLoader;
    }

    @Override
    public void setContextCache(ContextCache cache) {
        this.cache = cache;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

