/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.i18n;

import com.zutubi.i18n.MessageHandler;
import com.zutubi.i18n.bundle.BundleManager;
import com.zutubi.i18n.format.Formatter;
import com.zutubi.i18n.locale.LocaleManager;
import java.util.Locale;
import java.util.ResourceBundle;

public class DefaultMessageHandler
implements MessageHandler {
    private Formatter formatter = new Formatter();
    private BundleManager bundleManager;

    public DefaultMessageHandler(BundleManager bundleManager) {
        this.bundleManager = bundleManager;
    }

    public void setThreadLocale(Locale locale) {
        this.localeManager().setThreadLocale(locale);
    }

    public void setLocale(Locale locale) {
        this.localeManager().setLocale(locale);
    }

    public Locale getLocale() {
        return this.localeManager().getLocale();
    }

    public String format(Object context, String key) {
        return this.format(context, this.getLocale(), key);
    }

    public String format(Object context, Locale locale, String key) {
        for (ResourceBundle bundle : this.bundleManager.getBundles(context, locale)) {
            String formattedText = this.formatter.format(bundle, key);
            if (formattedText == null) continue;
            return formattedText;
        }
        return null;
    }

    public String format(Object context, String key, Object ... args) {
        for (ResourceBundle bundle : this.bundleManager.getBundles(context, this.getLocale())) {
            String formattedText = this.formatter.format(bundle, key, args);
            if (formattedText == null) continue;
            return formattedText;
        }
        return null;
    }

    public String format(Object context, Locale locale, String key, Object ... args) {
        for (ResourceBundle bundle : this.bundleManager.getBundles(context, locale)) {
            String formattedText = this.formatter.format(bundle, key, args);
            if (formattedText == null) continue;
            return formattedText;
        }
        return null;
    }

    public void clear() {
        this.bundleManager.clear();
    }

    private LocaleManager localeManager() {
        return LocaleManager.getManager();
    }
}

