/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.personal;

import com.zutubi.pulse.Version;
import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.personal.ConfigCommand;
import com.zutubi.pulse.personal.PatchArchive;
import com.zutubi.pulse.personal.PersonalBuildConfig;
import com.zutubi.pulse.personal.PersonalBuildException;
import com.zutubi.pulse.personal.PersonalBuildSupport;
import com.zutubi.pulse.personal.PersonalBuildUI;
import com.zutubi.pulse.personal.UserAbortException;
import com.zutubi.pulse.scm.SCMConfiguration;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.WorkingCopy;
import com.zutubi.pulse.scm.WorkingCopyFactory;
import com.zutubi.pulse.scm.WorkingCopyStatus;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.xmlrpc.PulseXmlRpcClient;
import com.zutubi.pulse.xmlrpc.PulseXmlRpcException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;

public class PersonalBuildClient
extends PersonalBuildSupport {
    private PersonalBuildConfig config;
    private String password;

    public PersonalBuildClient(PersonalBuildConfig config) {
        this.config = config;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkingCopy checkConfiguration() throws PersonalBuildException {
        this.debug("Verifying configuration with pulse server...", new Object[0]);
        this.checkRequiredConfig();
        try {
            WorkingCopy workingCopy;
            PulseXmlRpcClient rpc = new PulseXmlRpcClient(this.config.getPulseUrl());
            this.checkVersion(rpc);
            String token = null;
            try {
                this.debug("Logging in to pulse: url: " + this.config.getPulseUrl() + ", user: " + this.config.getPulseUser(), new Object[0]);
                token = rpc.login(this.config.getPulseUser(), this.getPassword());
                this.debug("Login successful.", new Object[0]);
                WorkingCopy wc = this.prepare(rpc, token);
                this.debug("Verified: personal build for project: " + this.config.getProject() + ", specification: " + this.config.getSpecification() + ".", new Object[0]);
                workingCopy = wc;
            }
            catch (PersonalBuildException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw new PersonalBuildException("Unable to log in to pulse server: " + e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    rpc.failSafeLogout(token);
                    throw throwable;
                }
            }
            rpc.failSafeLogout(token);
            return workingCopy;
        }
        catch (MalformedURLException e) {
            throw new PersonalBuildException("Invalid pulse server URL '" + this.config.getPulseUrl() + "'", (Throwable)e);
        }
    }

    private String getPassword() {
        if (this.password == null) {
            this.password = this.config.getPulsePassword();
            if (this.password == null) {
                this.password = this.passwordPrompt("Pulse password");
                if (this.password == null) {
                    this.password = "";
                }
            }
        }
        return this.password;
    }

    private void checkVersion(PulseXmlRpcClient rpc) throws PersonalBuildException {
        int ourBuild = Version.getVersion().getBuildNumberAsInt();
        int confirmedBuild = this.config.getConfirmedVersion();
        this.debug("Checking pulse server version...", new Object[0]);
        try {
            int serverBuild = rpc.getVersion();
            if (serverBuild != ourBuild) {
                this.debug("Server build (%d) does not match local build (%d)", new Object[]{serverBuild, ourBuild});
                if (serverBuild != confirmedBuild) {
                    String ourVersion;
                    String serverVersion = Version.buildNumberToVersion((int)serverBuild);
                    String question = serverVersion.equals(ourVersion = Version.buildNumberToVersion((int)ourBuild)) ? String.format("Server build (%d) does not match tools build (%d).  Continue anyway?", serverBuild, ourBuild) : String.format("Server version (%s) does not match tools version (%s).  Continue anyway?", serverVersion, ourVersion);
                    PersonalBuildUI.Response response = this.ynaPrompt(question, PersonalBuildUI.Response.NO);
                    if (response == PersonalBuildUI.Response.ALWAYS) {
                        this.config.setConfirmedVersion(serverBuild);
                    } else if (!response.isAffirmative()) {
                        throw new UserAbortException();
                    }
                }
            }
            this.debug("Version accepted.", new Object[0]);
        }
        catch (PulseXmlRpcException e) {
            throw new PersonalBuildException("Unable to get pulse server version: " + e.getMessage(), (Throwable)e);
        }
    }

    private void checkRequiredConfig() throws PersonalBuildException {
        PersonalBuildUI.Response response;
        if (this.config.getPulseUrl() == null) {
            response = this.ynPrompt("No pulse server configured.  Configure one now?", PersonalBuildUI.Response.YES);
            if (response.isAffirmative()) {
                new ConfigCommand().setupPulseConfig(this.getUi(), this.config);
            } else {
                throw new PersonalBuildException("Required property 'pulse.url' not specified.");
            }
        }
        if (this.config.getProject() == null) {
            response = this.ynPrompt("No pulse project configured.  Configure one now?", PersonalBuildUI.Response.YES);
            if (response.isAffirmative()) {
                new ConfigCommand().setupLocalConfig(this.getUi(), this.config);
            } else {
                throw new PersonalBuildException("Required property 'project' not specified.");
            }
        }
    }

    private WorkingCopy prepare(PulseXmlRpcClient rpc, String token) throws PersonalBuildException {
        try {
            this.debug("Checking configuration and obtaining project SCM details...", new Object[0]);
            SCMConfiguration scmConfiguration = rpc.preparePersonalBuild(token, this.config.getProject(), this.config.getSpecification());
            this.debug("Configuration accepted.", new Object[0]);
            String scmType = scmConfiguration.getType();
            this.debug("SCM type: " + scmType, new Object[0]);
            WorkingCopy wc = WorkingCopyFactory.create((String)scmType, (File)this.config.getBase(), (Config)this.config);
            if (wc == null) {
                throw new PersonalBuildException("Personal builds are not supported for this SCM (" + scmType + ")");
            }
            wc.setUI(this.getUi());
            if (this.config.getCheckRepository()) {
                this.debug("Checking working copy matches project SCM configuration", new Object[0]);
                if (!wc.matchesRepository(scmConfiguration.getRepositoryDetails())) {
                    PersonalBuildUI.Response response = this.ynaPrompt("This working copy may not match project '" + this.config.getProject() + "'.  Continue anyway?", PersonalBuildUI.Response.NO);
                    if (response.isPersistent()) {
                        this.config.setCheckRepository(!response.isAffirmative());
                    }
                    if (!response.isAffirmative()) {
                        throw new UserAbortException();
                    }
                } else {
                    this.debug("Configuration matches.", new Object[0]);
                }
            }
            return wc;
        }
        catch (PersonalBuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersonalBuildException("Unable to prepare personal build: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchArchive preparePatch(WorkingCopy wc, File patchFile, String ... spec) throws PersonalBuildException {
        WorkingCopyStatus status;
        Revision rev;
        try {
            this.status("Updating working copy...");
            this.enterContext();
            try {
                rev = wc.update();
            }
            finally {
                this.exitContext();
            }
            this.status("Update complete.");
        }
        catch (SCMException e) {
            throw new PersonalBuildException("Unable to update working copy: " + e.getMessage(), (Throwable)e);
        }
        this.status("Getting working copy status...");
        this.enterContext();
        try {
            status = this.getStatus(wc, spec);
            status.setRevision(rev);
        }
        finally {
            this.exitContext();
        }
        this.status("Status retrieved.");
        if (status.hasChanges()) {
            PatchArchive patchArchive;
            this.status("Creating patch archive...");
            this.enterContext();
            try {
                patchArchive = new PatchArchive(status, patchFile, this.getUi());
            }
            finally {
                this.exitContext();
            }
            this.status("Patch created.");
            return patchArchive;
        }
        return null;
    }

    public WorkingCopyStatus getStatus(WorkingCopy wc, String ... spec) throws PersonalBuildException {
        WorkingCopyStatus status;
        try {
            status = wc.getLocalStatus(spec);
        }
        catch (SCMException e) {
            throw new PersonalBuildException("Unable to get working copy status: " + e.getMessage(), (Throwable)e);
        }
        if (!status.inConsistentState()) {
            throw new PersonalBuildException("Working copy is not in a consistent state.");
        }
        return status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long sendRequest(PatchArchive patch) throws PersonalBuildException {
        HttpClient client = new HttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.config.getPulseUser(), this.getPassword());
        client.getState().setCredentials(new AuthScope(null, -1), (Credentials)credentials);
        client.getParams().setAuthenticationPreemptive(true);
        PostMethod post = new PostMethod(this.config.getPulseUrl() + "/personal/personalBuild.action");
        post.setDoAuthentication(true);
        try {
            Part[] parts = new Part[]{new StringPart("version", Version.getVersion().getBuildNumber()), new StringPart("project", this.config.getProject()), new StringPart("specification", this.config.getSpecification()), new FilePart("patch.zip", patch.getPatchFile())};
            post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
            this.status("Sending patch to pulse server...");
            int status = client.executeMethod((HttpMethod)post);
            if (status != 200) throw new PersonalBuildException("Pulse server returned error code " + status + " (" + HttpStatus.getStatusText((int)status) + ")");
            String response = IOUtils.inputStreamToString((InputStream)post.getResponseBodyAsStream());
            if (!response.startsWith("OK:")) throw new PersonalBuildException("Pulse server responded with: " + response);
            String numberStr = response.substring(3);
            try {
                long number = Long.parseLong(numberStr);
                this.status("Patch accepted: personal build " + numberStr + ".");
                long l = number;
                return l;
            }
            catch (NumberFormatException e) {
                try {
                    throw new PersonalBuildException("Pulse server returned invalid build number '" + numberStr + "'");
                }
                catch (IOException e2) {
                    throw new PersonalBuildException("I/O error sending patch to pulse server: " + e2.getMessage(), (Throwable)e2);
                }
            }
        }
        finally {
            post.releaseConnection();
        }
    }
}

