/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.personal;

import com.zutubi.pulse.personal.PersonalBuildUI;
import com.zutubi.pulse.util.PasswordReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class ConsoleUI
implements PersonalBuildUI {
    private BufferedReader inputReader = new BufferedReader(new InputStreamReader(System.in));
    private PasswordReader passwordReader = new PasswordReader(this.inputReader);
    private PersonalBuildUI.Verbosity verbosity;
    private String indent = "";

    private void fatal(String message) {
        this.print("Error: " + message, System.err);
        System.exit(1);
    }

    public void setVerbosity(PersonalBuildUI.Verbosity verbosity) {
        this.verbosity = verbosity;
    }

    public void debug(String message) {
        if (this.verbosity == PersonalBuildUI.Verbosity.VERBOSE) {
            this.print(message, System.out);
        }
    }

    public void status(String message) {
        if (this.verbosity != PersonalBuildUI.Verbosity.QUIET) {
            this.print(message, System.out);
        }
    }

    public void warning(String message) {
        this.print("Warning: " + message, System.err);
    }

    public void error(String message) {
        this.print("Error: " + message, System.err);
    }

    public void error(String message, Throwable throwable) {
        if (this.verbosity == PersonalBuildUI.Verbosity.VERBOSE) {
            throwable.printStackTrace(System.err);
        }
        this.error(message);
    }

    private void print(String message, PrintStream stream) {
        stream.println(this.indent + message);
    }

    public void enterContext() {
        this.indent = this.indent + "  ";
    }

    public void exitContext() {
        if (this.indent.length() >= 2) {
            this.indent = this.indent.substring(2);
        }
    }

    public String inputPrompt(String question) {
        System.out.print(question + ": ");
        try {
            return this.inputReader.readLine();
        }
        catch (IOException e) {
            this.fatal("Unable to prompt for input: " + e.getMessage());
            return null;
        }
    }

    public String inputPrompt(String prompt, String defaultResponse) {
        System.out.print(prompt + " [default: " + defaultResponse + "]: ");
        try {
            String response = this.inputReader.readLine();
            if (response.length() == 0) {
                response = defaultResponse;
            }
            return response;
        }
        catch (IOException e) {
            this.fatal("Unable to prompt for input: " + e.getMessage());
            return defaultResponse;
        }
    }

    public String passwordPrompt(String question) {
        String result = this.passwordReader.readPassword(question + ": ");
        if (result == null) {
            this.fatal("Unable to prompt for password");
        }
        return result;
    }

    public PersonalBuildUI.Response ynPrompt(String question, PersonalBuildUI.Response defaultResponse) {
        String choices = "Yes/No";
        switch (defaultResponse) {
            case YES: {
                choices = choices + " [default: Yes]";
                break;
            }
            case NO: {
                choices = choices + " [default: No]";
            }
        }
        try {
            System.out.println(question);
            PersonalBuildUI.Response response = null;
            while (response == null) {
                System.out.print(choices + "> ");
                String input = this.inputReader.readLine();
                response = PersonalBuildUI.Response.fromInput((String)input, (PersonalBuildUI.Response)defaultResponse, (PersonalBuildUI.Response[])new PersonalBuildUI.Response[]{PersonalBuildUI.Response.YES, PersonalBuildUI.Response.NO});
            }
            return response;
        }
        catch (IOException e) {
            this.fatal("Unable to prompt for input: " + e.getMessage());
            return null;
        }
    }

    public PersonalBuildUI.Response ynaPrompt(String question, PersonalBuildUI.Response defaultResponse) {
        String choices = "Yes/No/Always";
        switch (defaultResponse) {
            case YES: {
                choices = choices + " [default: Yes]";
                break;
            }
            case NO: {
                choices = choices + " [default: No]";
                break;
            }
            case ALWAYS: {
                choices = choices + " [default: Always]";
            }
        }
        try {
            System.out.println(question);
            PersonalBuildUI.Response response = null;
            while (response == null) {
                System.out.print(choices + "> ");
                String input = this.inputReader.readLine();
                response = PersonalBuildUI.Response.fromInput((String)input, (PersonalBuildUI.Response)defaultResponse, (PersonalBuildUI.Response[])new PersonalBuildUI.Response[]{PersonalBuildUI.Response.YES, PersonalBuildUI.Response.NO, PersonalBuildUI.Response.ALWAYS});
            }
            return response;
        }
        catch (IOException e) {
            this.fatal("Unable to prompt for input: " + e.getMessage());
            return null;
        }
    }
}

