/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.local;

import com.zutubi.pulse.BuildContext;
import com.zutubi.pulse.core.Bootstrapper;
import com.zutubi.pulse.core.FileLoader;
import com.zutubi.pulse.core.FileResourceRepository;
import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.core.PulseException;
import com.zutubi.pulse.core.PulseFileLoader;
import com.zutubi.pulse.core.RecipePaths;
import com.zutubi.pulse.core.RecipeProcessor;
import com.zutubi.pulse.core.RecipeRequest;
import com.zutubi.pulse.core.ResourceFileLoader;
import com.zutubi.pulse.core.ResourceRepository;
import com.zutubi.pulse.core.model.Resource;
import com.zutubi.pulse.events.DefaultEventManager;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.local.BuildStatusPrinter;
import com.zutubi.pulse.local.LocalBootstrapper;
import com.zutubi.pulse.local.LocalRecipePaths;
import com.zutubi.pulse.resources.ResourceDiscoverer;
import com.zutubi.pulse.util.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class LocalBuild {
    public static void main(String[] argv) {
        String pulseFile = "pulse.xml";
        String resourcesFile = null;
        String outputDir = "pulse.out";
        String recipe = null;
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"output-dir");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"pulse-file");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)"recipe");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.withLongOpt((String)"resources-file");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'e'));
        PosixParser parser = new PosixParser();
        try {
            CommandLine commandLine = parser.parse(options, argv, true);
            if (commandLine.hasOption('p')) {
                pulseFile = commandLine.getOptionValue('p');
            }
            if (commandLine.hasOption('r')) {
                recipe = commandLine.getOptionValue('r');
            }
            if (commandLine.hasOption('e')) {
                resourcesFile = commandLine.getOptionValue('e');
            }
            if (commandLine.hasOption('o')) {
                outputDir = commandLine.getOptionValue('o');
            }
            LocalBuild b = new LocalBuild();
            File baseDir = new File(System.getProperty("user.dir"));
            b.runBuild(baseDir, pulseFile, recipe, resourcesFile, outputDir);
        }
        catch (Exception e) {
            LocalBuild.fatal(e);
        }
    }

    private FileResourceRepository createRepository(String resourcesFile) throws PulseException {
        FileResourceRepository fileResourceRepository;
        if (resourcesFile == null) {
            return new FileResourceRepository();
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(resourcesFile);
            fileResourceRepository = ResourceFileLoader.load((InputStream)stream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new PulseException("Unable to open resources file '" + resourcesFile + "'");
            }
            catch (Throwable throwable) {
                IOUtils.close(stream);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)stream);
        return fileResourceRepository;
    }

    public void runBuild(File baseDir, String pulseFileName, String recipe, String resourcesFile, String outputDir) throws PulseException {
        this.printPrologue(pulseFileName, resourcesFile, outputDir);
        FileResourceRepository repository = this.createRepository(resourcesFile);
        this.discoverResources(repository);
        LocalRecipePaths paths = new LocalRecipePaths(baseDir, outputDir);
        if (!paths.getBaseDir().isDirectory()) {
            throw new PulseException("Base directory '" + paths.getBaseDir().getAbsolutePath() + "' does not exist");
        }
        File logFile = new File(baseDir, "build.log");
        FileOutputStream logStream = null;
        try {
            logStream = new FileOutputStream(logFile);
            DefaultEventManager manager = new DefaultEventManager();
            ObjectFactory objectFactory = new ObjectFactory();
            PulseFileLoader fileLoader = new PulseFileLoader();
            fileLoader.setObjectFactory(objectFactory);
            manager.register((EventListener)new BuildStatusPrinter(paths.getBaseDir(), logStream));
            LocalBootstrapper bootstrapper = new LocalBootstrapper();
            RecipeProcessor processor = new RecipeProcessor();
            processor.setEventManager((EventManager)manager);
            processor.setFileLoader((FileLoader)fileLoader);
            RecipeRequest request = new RecipeRequest(0L, (Bootstrapper)bootstrapper, this.loadPulseFile(baseDir, pulseFileName), recipe);
            processor.build(request, (RecipePaths)paths, (ResourceRepository)repository, false, new BuildContext());
        }
        catch (FileNotFoundException e) {
            try {
                throw new PulseException("Unable to create log file '" + logFile.getPath() + "': " + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.close(logStream);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)logStream);
        this.printEpilogue(logFile);
    }

    private void discoverResources(FileResourceRepository repository) {
        ResourceDiscoverer discoverer = new ResourceDiscoverer();
        List resources = discoverer.discover();
        for (Resource r : resources) {
            if (repository.hasResource(r.getName())) continue;
            repository.addResource(r);
        }
    }

    private String loadPulseFile(File baseDir, String pulseFileName) throws PulseException {
        String result;
        File pulseFile = new File(baseDir, pulseFileName);
        FileInputStream pulseFileInputStream = null;
        try {
            pulseFileInputStream = new FileInputStream(pulseFile);
            result = IOUtils.inputStreamToString((InputStream)pulseFileInputStream);
        }
        catch (IOException e) {
            try {
                throw new PulseException("Unable to load pulse file '" + pulseFile.getPath() + "': " + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.close(pulseFileInputStream);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)pulseFileInputStream);
        return result;
    }

    private void printPrologue(String pulseFile, String resourcesFile, String outputDir) {
        System.out.println("pulse file      : '" + pulseFile + "'");
        System.out.println("output directory: '" + outputDir + "'");
        if (resourcesFile != null) {
            System.out.println("resources file  : '" + resourcesFile + "'");
        }
        System.out.println();
    }

    private void printEpilogue(File logFile) {
        System.out.println();
        System.out.println("Build report saved to '" + logFile.getPath() + "'.");
    }

    private static void fatal(Throwable throwable) {
        System.err.println(throwable.getMessage());
        System.exit(1);
    }
}

