/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.local;

import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.Feature;
import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.core.model.Result;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.core.model.StoredFileArtifact;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.events.build.CommandCommencedEvent;
import com.zutubi.pulse.events.build.CommandCompletedEvent;
import com.zutubi.pulse.events.build.RecipeCommencedEvent;
import com.zutubi.pulse.events.build.RecipeCompletedEvent;
import com.zutubi.pulse.events.build.RecipeErrorEvent;
import com.zutubi.pulse.events.build.RecipeEvent;
import com.zutubi.pulse.local.Indenter;
import com.zutubi.pulse.util.ForkOutputStream;
import com.zutubi.pulse.util.TimeStamps;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildStatusPrinter
implements EventListener {
    private Indenter indenter;
    private String baseDir;
    private RecipeResult result;
    private Locale locale;

    public BuildStatusPrinter(File base, OutputStream logStream) {
        ForkOutputStream fork = new ForkOutputStream(new OutputStream[]{System.out, logStream});
        this.indenter = new Indenter(new PrintStream((OutputStream)fork), "  ");
        this.baseDir = base.getAbsolutePath() + File.separatorChar;
        this.result = new RecipeResult();
        this.locale = Locale.getDefault();
    }

    public void handleEvent(Event event) {
        RecipeEvent recipeEvent = (RecipeEvent)event;
        if (recipeEvent instanceof RecipeCommencedEvent) {
            this.handleRecipeCommenced((RecipeCommencedEvent)recipeEvent);
        } else if (recipeEvent instanceof CommandCommencedEvent) {
            this.handleCommandCommenced((CommandCommencedEvent)recipeEvent);
        } else if (recipeEvent instanceof CommandCompletedEvent) {
            this.handleCommandCompleted((CommandCompletedEvent)recipeEvent);
        } else if (recipeEvent instanceof RecipeCompletedEvent) {
            this.handleRecipeCompleted((RecipeCompletedEvent)recipeEvent);
        } else if (recipeEvent instanceof RecipeErrorEvent) {
            this.handleRecipeError((RecipeErrorEvent)recipeEvent);
        }
    }

    private void handleRecipeCommenced(RecipeCommencedEvent event) {
        String recipeName = event.getName();
        if (recipeName == null) {
            recipeName = "<default>";
        }
        this.result.commence(event.getName(), event.getStartTime());
        this.indenter.println("[" + recipeName + "]");
        this.indenter.indent();
        this.indenter.println("commenced: " + TimeStamps.getPrettyDate((long)event.getStartTime(), (Locale)this.locale));
    }

    private void handleCommandCommenced(CommandCommencedEvent event) {
        this.indenter.println("[" + event.getName() + "]");
        this.indenter.indent();
        this.indenter.println("commenced: " + TimeStamps.getPrettyDate((long)event.getStartTime(), (Locale)this.locale));
    }

    private void handleCommandCompleted(CommandCompletedEvent event) {
        CommandResult commandResult = event.getResult();
        this.result.add(commandResult);
        this.indenter.println("completed: " + commandResult.getStamps().getPrettyEndDate(this.locale));
        this.indenter.println("elapsed  : " + commandResult.getStamps().getPrettyElapsed());
        this.indenter.println("result   : " + commandResult.getState().getPrettyString());
        this.showMessages((Result)commandResult);
        List artifacts = commandResult.getArtifacts();
        if (artifacts.size() > 0) {
            this.showArtifacts(commandResult, artifacts);
        }
        this.indenter.println();
        this.indenter.dedent();
    }

    private void showMessages(Result result) {
        if (result.hasDirectMessages(Feature.Level.ERROR)) {
            this.indenter.println("errors   :");
            this.showMessages(result, Feature.Level.ERROR);
        }
        if (result.hasDirectMessages(Feature.Level.WARNING)) {
            this.indenter.println("warnings :");
            this.showMessages(result, Feature.Level.WARNING);
        }
        if (result.hasDirectMessages(Feature.Level.INFO)) {
            this.indenter.println("info     :");
            this.showMessages(result, Feature.Level.INFO);
        }
    }

    private void showMessages(Result result, Feature.Level level) {
        this.indenter.indent();
        for (Feature feature : result.getFeatures(level)) {
            this.indenter.println(feature.getSummary());
        }
        this.indenter.dedent();
    }

    private void showArtifacts(CommandResult result, List<StoredArtifact> artifacts) {
        this.indenter.println("artifacts:");
        this.indenter.indent();
        for (StoredArtifact artifact : artifacts) {
            this.indenter.println("* " + artifact.getName());
            this.indenter.indent();
            for (StoredFileArtifact fileArtifact : artifact.getChildren()) {
                this.indenter.println("* " + this.getFilePath(result, fileArtifact.getPath()));
                for (Feature.Level level : Feature.Level.values()) {
                    List features = fileArtifact.getFeatures(level);
                    if (features.size() <= 0) continue;
                    this.indenter.indent();
                    this.showFeatures(level, features);
                    this.indenter.dedent();
                }
            }
            this.indenter.dedent();
        }
        this.indenter.dedent();
    }

    private String getFilePath(CommandResult commandResult, String name) {
        File path = new File(commandResult.getOutputDir(), name);
        String result = path.getPath();
        if (result.startsWith(this.baseDir)) {
            result = result.substring(this.baseDir.length());
        }
        return result;
    }

    private void showFeatures(Feature.Level level, List<Feature> features) {
        this.indenter.println(level.toString().toLowerCase() + " features:");
        this.indenter.indent();
        for (Feature f : features) {
            this.indenter.println("* " + f.getSummary());
        }
        this.indenter.dedent();
    }

    private void handleRecipeCompleted(RecipeCompletedEvent event) {
        this.result.update(event.getResult());
        this.complete();
    }

    private void handleRecipeError(RecipeErrorEvent event) {
        this.result.error(event.getErrorMessage());
        this.complete();
    }

    private void complete() {
        this.result.complete();
        this.indenter.println("completed: " + this.result.getStamps().getPrettyEndDate(this.locale));
        this.indenter.println("elapsed  : " + this.result.getStamps().getPrettyElapsed());
        this.indenter.println("result   : " + this.result.getState().getPrettyString());
        this.showMessages((Result)this.result);
        this.indenter.dedent();
    }

    public Class[] getHandledEvents() {
        return new Class[]{RecipeEvent.class};
    }
}

