/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNRevisionProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNDirectory;
import org.tmatesoft.svn.core.internal.wc.SVNEntries;
import org.tmatesoft.svn.core.internal.wc.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternalInfo;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNWCClient
extends SVNBasicClient {
    public SVNWCClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    protected SVNWCClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doGetFileContents(File path, SVNRevision pegRevision, SVNRevision revision, boolean expandKeywords, OutputStream dst) throws SVNException {
        SVNWCAccess wcAccess;
        if (dst == null) {
            return;
        }
        if (revision == null || !revision.isValid()) {
            revision = SVNRevision.WORKING;
        }
        if (revision == SVNRevision.COMMITTED) {
            revision = SVNRevision.BASE;
        }
        if ("".equals((wcAccess = this.createWCAccess(path)).getTargetName()) || wcAccess.getTarget() != wcAccess.getAnchor()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_DIRECTORY, "''{0}'' refers to a directory", path, 1);
            SVNErrorManager.error(err);
        }
        this.checkCancelled();
        String name = wcAccess.getTargetName();
        if (revision == SVNRevision.WORKING || revision == SVNRevision.BASE) {
            File file = wcAccess.getAnchor().getBaseFile(name, false);
            boolean delete = false;
            SVNEntry entry = wcAccess.getAnchor().getEntries().getEntry(wcAccess.getTargetName(), false);
            if (entry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control or doesn''t exist", path, 1);
                SVNErrorManager.error(err);
            }
            if (revision == SVNRevision.BASE) {
                if (expandKeywords) {
                    delete = true;
                    file = wcAccess.getAnchor().getBaseFile(name, true).getParentFile();
                    file = SVNFileUtil.createUniqueFile(file, name, ".tmp");
                    SVNTranslator.translate(wcAccess.getAnchor(), name, SVNFileUtil.getBasePath(wcAccess.getAnchor().getBaseFile(name, false)), SVNFileUtil.getBasePath(file), true, false);
                }
            } else if (!expandKeywords) {
                delete = true;
                file = wcAccess.getAnchor().getBaseFile(name, true).getParentFile();
                file = SVNFileUtil.createUniqueFile(file, name, ".tmp");
                SVNTranslator.translate(wcAccess.getAnchor(), name, name, SVNFileUtil.getBasePath(file), false, false);
            } else {
                file = wcAccess.getAnchor().getFile(name);
            }
            Object var13_15 = null;
            if (file == null || !file.exists()) return;
            InputStream is = SVNFileUtil.openFileForReading(file);
            try {
                int r;
                while ((r = is.read()) >= 0) {
                    dst.write(r);
                }
            }
            catch (IOException e) {
                SVNDebugLog.logInfo(e);
                return;
            }
            finally {
                SVNFileUtil.closeFile(is);
                if (delete) {
                    file.delete();
                }
            }
            return;
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (file == null || !file.exists()) throw throwable;
                is = SVNFileUtil.openFileForReading(file);
                try {
                    int r;
                    while ((r = is.read()) >= 0) {
                        dst.write(r);
                    }
                }
                catch (IOException e) {
                    try {}
                    catch (Throwable throwable2) {
                        SVNFileUtil.closeFile(is);
                        if (!delete) throw throwable2;
                        file.delete();
                        throw throwable2;
                    }
                    SVNDebugLog.logInfo(e);
                    SVNFileUtil.closeFile(is);
                    if (!delete) throw throwable;
                    file.delete();
                    throw throwable;
                }
                SVNFileUtil.closeFile(is);
                if (!delete) throw throwable;
                file.delete();
                throw throwable;
            }
        }
        SVNRepository repos = this.createRepository(null, path, pegRevision, revision);
        this.checkCancelled();
        long revNumber = this.getRevisionNumber(revision, repos, path);
        this.checkCancelled();
        if (!expandKeywords) {
            repos.getFile("", revNumber, null, new SVNCancellableOutputStream(dst, this));
            return;
        }
        String adminDir = SVNFileUtil.getAdminDirectoryName();
        File tmpFile = SVNFileUtil.createUniqueFile(new File(path.getParentFile(), adminDir + "/tmp/text-base"), path.getName(), ".tmp");
        File tmpFile2 = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            int r;
            os = SVNFileUtil.openFileForWriting(tmpFile);
            HashMap properties = new HashMap();
            repos.getFile("", revNumber, properties, new SVNCancellableOutputStream(os, this));
            SVNFileUtil.closeFile(os);
            os = null;
            String keywords = (String)properties.get("svn:keywords");
            String eol = (String)properties.get("svn:eol-style");
            byte[] eolBytes = SVNTranslator.getWorkingEOL(eol);
            Map keywordsMap = SVNTranslator.computeKeywords(keywords, repos.getLocation().toString(), (String)properties.get("svn:entry:last-author"), (String)properties.get("svn:entry:committed-date"), (String)properties.get("svn:entry:committed-rev"));
            tmpFile2 = SVNFileUtil.createUniqueFile(new File(path.getParentFile(), adminDir + "/tmp/text-base"), path.getName(), ".tmp");
            SVNTranslator.translate(tmpFile, tmpFile2, eolBytes, keywordsMap, false, true);
            is = SVNFileUtil.openFileForReading(tmpFile2);
            while ((r = is.read()) >= 0) {
                dst.write(r);
            }
            Object var23_38 = null;
        }
        catch (Throwable throwable) {
            Object var23_40 = null;
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
            if (tmpFile != null) {
                tmpFile.delete();
            }
            if (tmpFile2 == null) throw throwable;
            tmpFile2.delete();
            throw throwable;
        }
        SVNFileUtil.closeFile(os);
        SVNFileUtil.closeFile(is);
        if (tmpFile != null) {
            tmpFile.delete();
        }
        if (tmpFile2 == null) return;
        tmpFile2.delete();
        {
            return;
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e);
                Object var23_39 = null;
                SVNFileUtil.closeFile(os);
                SVNFileUtil.closeFile(is);
                if (tmpFile != null) {
                    tmpFile.delete();
                }
                if (tmpFile2 == null) return;
                tmpFile2.delete();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGetFileContents(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean expandKeywords, OutputStream dst) throws SVNException {
        revision = revision == null || !revision.isValid() ? SVNRevision.HEAD : revision;
        HashMap properties = new HashMap();
        SVNRepository repos = this.createRepository(url, null, pegRevision, revision);
        this.checkCancelled();
        long revisionNumber = this.getRevisionNumber(revision, repos, null);
        this.checkCancelled();
        SVNNodeKind nodeKind = repos.checkPath("", revisionNumber);
        this.checkCancelled();
        if (nodeKind == SVNNodeKind.DIR) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_DIRECTORY, "URL ''{0}'' refers to a directory", url, 1);
            SVNErrorManager.error(err);
        }
        FileOutputStream os = null;
        InputStream is = null;
        File file = null;
        File file2 = null;
        try {
            file = File.createTempFile("svn-contents", ".tmp");
            file2 = File.createTempFile("svn-contents", ".tmp");
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            if (file != null) {
                file.delete();
            }
            if (file2 != null) {
                file2.delete();
            }
            SVNErrorManager.error(err, e);
            return;
        }
        try {
            try {
                int r;
                os = new FileOutputStream(file);
                repos.getFile("", revisionNumber, properties, new SVNCancellableOutputStream(os, this));
                ((OutputStream)os).close();
                os = null;
                if (expandKeywords) {
                    String keywords = (String)properties.get("svn:keywords");
                    String eol = (String)properties.get("svn:eol-style");
                    byte[] eolBytes = SVNTranslator.getWorkingEOL(eol);
                    Map keywordsMap = SVNTranslator.computeKeywords(keywords, url.toString(), (String)properties.get("svn:entry:last-author"), (String)properties.get("svn:entry:committed-date"), (String)properties.get("svn:entry:committed-rev"));
                    SVNTranslator.translate(file, file2, eolBytes, keywordsMap, false, true);
                } else {
                    file2 = file;
                }
                is = SVNFileUtil.openFileForReading(file2);
                while ((r = is.read()) >= 0) {
                    dst.write(r);
                }
                Object var20_23 = null;
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e);
                Object var20_24 = null;
                SVNFileUtil.closeFile(os);
                SVNFileUtil.closeFile(is);
                if (file != null) {
                    file.delete();
                }
                if (file2 == null) return;
                file2.delete();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var20_25 = null;
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
            if (file != null) {
                file.delete();
            }
            if (file2 == null) throw throwable;
            file2.delete();
            throw throwable;
        }
        SVNFileUtil.closeFile(os);
        SVNFileUtil.closeFile(is);
        if (file != null) {
            file.delete();
        }
        if (file2 == null) return;
        file2.delete();
    }

    public void doCleanup(File path) throws SVNException {
        SVNErrorMessage err;
        SVNFileType fType = SVNFileType.getType(path);
        if (fType == SVNFileType.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' does not exist", path);
            SVNErrorManager.error(err);
        } else if (fType == SVNFileType.FILE || fType == SVNFileType.SYMLINK) {
            path = path.getParentFile();
        }
        if (!SVNWCAccess.isVersionedDirectory(path)) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", path);
            SVNErrorManager.error(err);
        }
        SVNWCAccess wcAccess = this.createWCAccess(path);
        wcAccess.open(true, true, true);
        wcAccess.getAnchor().cleanup();
        wcAccess.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetProperty(File path, String propName, String propValue, boolean force, boolean recursive, ISVNPropertyHandler handler) throws SVNException {
        SVNErrorMessage err;
        if (SVNRevisionProperty.isRevisionProperty(propName = SVNWCClient.validatePropertyName(propName))) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Revision property ''{0}'' not allowed in this context", propName);
            SVNErrorManager.error(err);
        } else if (propName.startsWith("svn:wc:")) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop , thus not accessible to clients", propName);
            SVNErrorManager.error(err);
        }
        propValue = SVNWCClient.validatePropertyValue(propName, propValue, force);
        SVNWCAccess wcAccess = this.createWCAccess(path);
        try {
            wcAccess.open(true, recursive);
            this.doSetLocalProperty(wcAccess.getAnchor(), wcAccess.getTargetName(), propName, propValue, force, recursive, true, handler);
        }
        finally {
            wcAccess.close(true);
        }
    }

    public void doSetRevisionProperty(File path, SVNRevision revision, String propName, String propValue, boolean force, ISVNPropertyHandler handler) throws SVNException {
        propName = SVNWCClient.validatePropertyName(propName);
        propValue = SVNWCClient.validatePropertyValue(propName, propValue, force);
        SVNURL url = this.getURL(path);
        this.doSetRevisionProperty(url, revision, propName, propValue, force, handler);
    }

    public void doSetRevisionProperty(SVNURL url, SVNRevision revision, String propName, String propValue, boolean force, ISVNPropertyHandler handler) throws SVNException {
        SVNErrorMessage err;
        propName = SVNWCClient.validatePropertyName(propName);
        propValue = SVNWCClient.validatePropertyValue(propName, propValue, force);
        if (!force && "svn:author".equals(propName) && propValue != null && propValue.indexOf(10) >= 0) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_REVISION_AUTHOR_CONTAINS_NEWLINE, "Value will not be set unless forced");
            SVNErrorManager.error(err);
        }
        if (propName.startsWith("svn:wc:")) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop , thus not accessible to clients", propName);
            SVNErrorManager.error(err);
        }
        SVNRepository repos = this.createRepository(url, null, SVNRevision.UNDEFINED, revision);
        long revNumber = this.getRevisionNumber(revision, repos, null);
        repos.setRevisionPropertyValue(revNumber, propName, propValue);
        if (handler != null) {
            handler.handleProperty(revNumber, new SVNPropertyData(propName, propValue));
        }
    }

    public SVNPropertyData doGetProperty(final File path, String propName, SVNRevision pegRevision, SVNRevision revision, boolean recursive) throws SVNException {
        final SVNPropertyData[] data = new SVNPropertyData[1];
        this.doGetProperty(path, propName, pegRevision, revision, recursive, new ISVNPropertyHandler(){

            public void handleProperty(File file, SVNPropertyData property) {
                if (data[0] == null && path.equals(file)) {
                    data[0] = property;
                }
            }

            public void handleProperty(SVNURL url, SVNPropertyData property) {
            }

            public void handleProperty(long revision, SVNPropertyData property) {
            }
        });
        return data[0];
    }

    public SVNPropertyData doGetProperty(final SVNURL url, String propName, SVNRevision pegRevision, SVNRevision revision, boolean recursive) throws SVNException {
        final SVNPropertyData[] data = new SVNPropertyData[1];
        this.doGetProperty(url, propName, pegRevision, revision, recursive, new ISVNPropertyHandler(){

            public void handleProperty(File file, SVNPropertyData property) {
            }

            public void handleProperty(long revision, SVNPropertyData property) {
            }

            public void handleProperty(SVNURL location, SVNPropertyData property) throws SVNException {
                if (data[0] == null && url.toString().equals(location.toString())) {
                    data[0] = property;
                }
            }
        });
        return data[0];
    }

    public void doGetProperty(File path, String propName, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNPropertyHandler handler) throws SVNException {
        if (propName != null && propName.startsWith("svn:wc:")) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop , thus not accessible to clients", propName);
            SVNErrorManager.error(err);
        }
        if (revision == null || !revision.isValid()) {
            revision = SVNRevision.WORKING;
        }
        SVNWCAccess wcAccess = this.createWCAccess(path);
        wcAccess.open(false, recursive);
        SVNEntry entry = wcAccess.getTargetEntry();
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", path);
            SVNErrorManager.error(err);
        }
        if (revision != SVNRevision.WORKING && revision != SVNRevision.BASE && revision != SVNRevision.COMMITTED) {
            SVNURL url = entry.getSVNURL();
            SVNRepository repository = this.createRepository(null, path, pegRevision, revision);
            long revisionNumber = this.getRevisionNumber(revision, repository, path);
            revision = SVNRevision.create(revisionNumber);
            this.doGetRemoteProperty(url, "", repository, propName, revision, recursive, handler);
        } else {
            this.doGetLocalProperty(wcAccess.getAnchor(), wcAccess.getTargetName(), propName, revision, recursive, handler);
        }
        wcAccess.close(false);
    }

    public void doGetProperty(SVNURL url, String propName, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNPropertyHandler handler) throws SVNException {
        if (propName != null && propName.startsWith("svn:wc:")) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop , thus not accessible to clients", propName);
            SVNErrorManager.error(err);
        }
        if (revision == null || !revision.isValid()) {
            revision = SVNRevision.HEAD;
        }
        SVNRepository repos = this.createRepository(url, null, pegRevision, revision);
        this.doGetRemoteProperty(url, "", repos, propName, revision, recursive, handler);
    }

    public void doGetRevisionProperty(File path, String propName, SVNRevision revision, ISVNPropertyHandler handler) throws SVNException {
        SVNErrorMessage err;
        if (propName != null && propName.startsWith("svn:wc:")) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop , thus not accessible to clients", propName);
            SVNErrorManager.error(err);
        }
        if (!revision.isValid()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Valid revision have to be specified to fetch revision property");
            SVNErrorManager.error(err);
        }
        SVNRepository repository = this.createRepository(null, path, SVNRevision.UNDEFINED, revision);
        long revisionNumber = this.getRevisionNumber(revision, repository, path);
        this.doGetRevisionProperty(repository, propName, revisionNumber, handler);
    }

    public void doGetRevisionProperty(SVNURL url, String propName, SVNRevision revision, ISVNPropertyHandler handler) throws SVNException {
        SVNErrorMessage err;
        if (propName != null && propName.startsWith("svn:wc:")) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop , thus not accessible to clients", propName);
            SVNErrorManager.error(err);
        }
        if (!revision.isValid()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Valid revision have to be specified to fetch revision property");
            SVNErrorManager.error(err);
        }
        SVNRepository repos = this.createRepository(url, true);
        long revNumber = this.getRevisionNumber(revision, repos, null);
        this.doGetRevisionProperty(repos, propName, revNumber, handler);
    }

    private void doGetRevisionProperty(SVNRepository repos, String propName, long revNumber, ISVNPropertyHandler handler) throws SVNException {
        if (propName != null) {
            String value = repos.getRevisionPropertyValue(revNumber, propName);
            if (value != null) {
                handler.handleProperty(revNumber, new SVNPropertyData(propName, value));
            }
        } else {
            HashMap props = new HashMap();
            repos.getRevisionProperties(revNumber, props);
            Iterator names = props.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                String value = (String)props.get(name);
                handler.handleProperty(revNumber, new SVNPropertyData(name, value));
            }
        }
    }

    public void doDelete(File path, boolean force, boolean dryRun) throws SVNException {
        this.doDelete(path, force, true, dryRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(File path, boolean force, boolean deleteFiles, boolean dryRun) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess(path);
        try {
            wcAccess.open(true, true, true);
            if (!force) {
                wcAccess.getAnchor().canScheduleForDeletion(wcAccess.getTargetName(), false);
            }
            if (!dryRun) {
                wcAccess.getAnchor().scheduleForDeletion(wcAccess.getTargetName(), deleteFiles);
            }
        }
        finally {
            wcAccess.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAdd(File path, boolean force, boolean mkdir, boolean climbUnversionedParents, boolean recursive) throws SVNException {
        File parent;
        SVNFileType fType = SVNFileType.getType(path);
        if (fType == SVNFileType.NONE && !mkdir) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' does not exist", path);
            SVNErrorManager.error(err);
        }
        if (climbUnversionedParents && (parent = path.getParentFile()) != null && SVNWCUtil.getWorkingCopyRoot(path, true) == null) {
            this.doAdd(parent, false, mkdir, climbUnversionedParents, false);
        }
        SVNWCAccess wcAccess = this.createWCAccess(path);
        try {
            wcAccess.open(true, recursive);
            String name = wcAccess.getTargetName();
            if ("".equals(name) && !force) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control", path);
                SVNErrorManager.error(err);
            }
            SVNDirectory dir = wcAccess.getAnchor();
            if (fType == SVNFileType.FILE || fType == SVNFileType.SYMLINK) {
                this.addSingleFile(dir, name);
            } else if (fType == SVNFileType.DIRECTORY && recursive) {
                this.addDirectory(wcAccess, wcAccess.getAnchor(), name, force);
            } else {
                dir.add(wcAccess.getTargetName(), mkdir, false);
            }
        }
        finally {
            wcAccess.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRevert(File path, boolean recursive) throws SVNException {
        File file;
        SVNWCAccess wcAccess = this.createWCAccess(path);
        boolean reverted = false;
        boolean replaced = false;
        SVNNodeKind kind = null;
        ArrayList<File> recursiveFiles = new ArrayList<File>();
        try {
            wcAccess.open(true, false);
            SVNEntry entry = wcAccess.getAnchor().getEntries().getEntry(wcAccess.getTargetName(), true);
            if (entry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", path);
                SVNErrorManager.error(err);
            }
            kind = entry.getKind();
            file = wcAccess.getAnchor().getFile(wcAccess.getTargetName());
            if (entry.isDirectory() && !entry.isScheduledForAddition() && !file.isDirectory()) {
                this.handleEvent(SVNEventFactory.createNotRevertedEvent(wcAccess, wcAccess.getAnchor(), entry), -1.0);
                return;
            }
            SVNEvent event = SVNEventFactory.createRevertedEvent(wcAccess, wcAccess.getAnchor(), entry);
            if (entry.isScheduledForAddition()) {
                boolean deleted = entry.isDeleted();
                if (entry.isFile()) {
                    wcAccess.getAnchor().destroy(entry.getName(), false);
                } else if (entry.isDirectory()) {
                    if ("".equals(wcAccess.getTargetName())) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OP_ON_CWD, "Cannot revert addition of the root directory; please try again from the parent directory");
                        SVNErrorManager.error(err);
                    }
                    if (!file.exists()) {
                        wcAccess.getAnchor().getEntries().deleteEntry(entry.getName());
                    } else {
                        wcAccess.open(true, true, true);
                        wcAccess.getAnchor().destroy(entry.getName(), false);
                    }
                }
                reverted = true;
                if (deleted && !"".equals(wcAccess.getTargetName())) {
                    SVNEntry replacement = wcAccess.getAnchor().getEntries().addEntry(entry.getName());
                    replacement.setDeleted(true);
                    replacement.setKind(kind);
                }
            } else if (entry.isScheduledForReplacement() || entry.isScheduledForDeletion()) {
                replaced = entry.isScheduledForReplacement();
                reverted = entry.isDirectory() && wcAccess.getAnchor() != wcAccess.getTarget() ? (reverted |= wcAccess.getTarget().revert("")) : (reverted |= wcAccess.getAnchor().revert(entry.getName()));
                reverted = true;
            } else {
                reverted = entry.isDirectory() && wcAccess.getAnchor() != wcAccess.getTarget() ? (reverted |= wcAccess.getTarget().revert("")) : (reverted |= wcAccess.getAnchor().revert(entry.getName()));
            }
            if (reverted) {
                SVNEntry inner;
                if (kind == SVNNodeKind.DIR && replaced) {
                    recursive = true;
                }
                if (!"".equals(wcAccess.getTargetName())) {
                    entry.unschedule();
                    entry.setConflictNew(null);
                    entry.setConflictOld(null);
                    entry.setConflictWorking(null);
                    entry.setPropRejectFile(null);
                }
                wcAccess.getAnchor().getEntries().save(false);
                if (kind == SVNNodeKind.DIR && wcAccess.getTarget() != wcAccess.getAnchor() && (inner = wcAccess.getTarget().getEntries().getEntry("", true)) != null) {
                    inner.unschedule();
                    inner.setConflictNew(null);
                    inner.setConflictOld(null);
                    inner.setConflictWorking(null);
                    inner.setPropRejectFile(null);
                }
                wcAccess.getTarget().getEntries().save(false);
            }
            if (!"".equals(wcAccess.getTargetName()) && wcAccess.getTarget() == wcAccess.getAnchor()) {
                recursive = false;
            }
            if (kind == SVNNodeKind.DIR && recursive) {
                this.checkCancelled();
                Iterator ents = wcAccess.getTarget().getEntries().entries(true);
                while (ents.hasNext()) {
                    SVNEntry childEntry = (SVNEntry)ents.next();
                    if ("".equals(childEntry.getName())) continue;
                    recursiveFiles.add(wcAccess.getTarget().getFile(childEntry.getName()));
                }
            }
            if (reverted) {
                this.handleEvent(event, -1.0);
            }
        }
        finally {
            wcAccess.close(true);
        }
        if (kind == SVNNodeKind.DIR && recursive) {
            Iterator files = recursiveFiles.iterator();
            while (files.hasNext()) {
                file = (File)files.next();
                this.doRevert(file, recursive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doResolve(File path, boolean recursive) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess(path);
        try {
            SVNEntry entry;
            wcAccess.open(true, recursive);
            String target = wcAccess.getTargetName();
            SVNDirectory dir = wcAccess.getAnchor();
            if (wcAccess.getTarget() != wcAccess.getAnchor()) {
                target = "";
                dir = wcAccess.getTarget();
            }
            if ((entry = dir.getEntries().getEntry(target, false)) == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", path);
                SVNErrorManager.error(err);
                return;
            }
            if (!recursive || entry.getKind() != SVNNodeKind.DIR) {
                if (dir.markResolved(target, true, true)) {
                    SVNEvent event = SVNEventFactory.createResolvedEvent(wcAccess, dir, entry);
                    this.handleEvent(event, -1.0);
                }
            } else {
                this.doResolveAll(wcAccess, dir);
            }
        }
        finally {
            wcAccess.close(true);
        }
    }

    private void doResolveAll(SVNWCAccess access, SVNDirectory dir) throws SVNException {
        this.checkCancelled();
        SVNEntries entries = dir.getEntries();
        ArrayList<SVNDirectory> childDirs = new ArrayList<SVNDirectory>();
        Iterator ents = entries.entries(false);
        while (ents.hasNext()) {
            SVNDirectory childDir;
            SVNEntry entry = (SVNEntry)ents.next();
            if ("".equals(entry.getName()) || entry.isFile()) {
                if (!dir.markResolved(entry.getName(), true, true)) continue;
                SVNEvent event = SVNEventFactory.createResolvedEvent(access, dir, entry);
                this.handleEvent(event, -1.0);
                continue;
            }
            if (!entry.isDirectory() || (childDir = dir.getChildDirectory(entry.getName())) == null) continue;
            childDirs.add(childDir);
        }
        entries.save(true);
        Iterator dirs = childDirs.iterator();
        while (dirs.hasNext()) {
            SVNDirectory child = (SVNDirectory)dirs.next();
            this.doResolveAll(access, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLock(File[] paths, boolean stealLock, String lockMessage) throws SVNException {
        SVNErrorMessage err;
        final HashMap<SVNURL, LockInfo> entriesMap = new HashMap<SVNURL, LockInfo>();
        for (int i = 0; i < paths.length; ++i) {
            SVNWCAccess wcAccess = this.createWCAccess(paths[i]);
            try {
                wcAccess.open(false, false);
                SVNEntry entry = wcAccess.getTargetEntry();
                if (entry == null || entry.isHidden()) {
                    err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", wcAccess.getTargetName());
                    SVNErrorManager.error(err);
                }
                if (entry.getURL() == null) {
                    err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", wcAccess.getTargetName());
                    SVNErrorManager.error(err);
                }
                SVNRevision revision = stealLock ? SVNRevision.UNDEFINED : SVNRevision.create(entry.getRevision());
                entriesMap.put(entry.getSVNURL(), new LockInfo(paths[i], revision));
                continue;
            }
            finally {
                wcAccess.close(false);
            }
        }
        this.checkCancelled();
        SVNURL[] urls = entriesMap.keySet().toArray(new SVNURL[entriesMap.size()]);
        HashSet<String> urlPaths = new HashSet<String>();
        SVNURL topURL = SVNURLUtil.condenceURLs(urls, urlPaths, false);
        if (urlPaths.isEmpty()) {
            urlPaths.add("");
        }
        if (topURL == null) {
            err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "Paths belongs to different repositories");
            SVNErrorManager.error(err);
        }
        HashMap<String, Long> pathsRevisionsMap = new HashMap<String, Long>();
        Iterator encodedPaths = urlPaths.iterator();
        while (encodedPaths.hasNext()) {
            String encodedPath = (String)encodedPaths.next();
            SVNURL fullURL = topURL.appendPath(encodedPath, true);
            LockInfo lockInfo = (LockInfo)entriesMap.get(fullURL);
            encodedPath = SVNEncodingUtil.uriDecode(encodedPath);
            if (lockInfo.myRevision == SVNRevision.UNDEFINED) {
                pathsRevisionsMap.put(encodedPath, null);
                continue;
            }
            pathsRevisionsMap.put(encodedPath, new Long(lockInfo.myRevision.getNumber()));
        }
        SVNRepository repository = this.createRepository(topURL, true);
        final SVNURL rootURL = repository.getRepositoryRoot(true);
        repository.lock(pathsRevisionsMap, lockMessage, stealLock, new ISVNLockHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                SVNURL fullURL = rootURL.appendPath(path, false);
                LockInfo lockInfo = (LockInfo)entriesMap.get(fullURL);
                SVNWCAccess wcAccess = SVNWCClient.this.createWCAccess(lockInfo.myFile);
                if (error == null) {
                    try {
                        wcAccess.open(true, false);
                        SVNEntry entry = wcAccess.getTargetEntry();
                        entry.setLockToken(lock.getID());
                        entry.setLockComment(lock.getComment());
                        entry.setLockOwner(lock.getOwner());
                        entry.setLockCreationDate(SVNTimeUtil.formatDate(lock.getCreationDate()));
                        if (wcAccess.getAnchor().getProperties(entry.getName(), false).getPropertyValue("svn:needs-lock") != null) {
                            SVNFileUtil.setReadonly(wcAccess.getAnchor().getFile(entry.getName()), false);
                        }
                        if (wcAccess.getAnchor().getProperties(entry.getName(), false).getPropertyValue("svn:executable") != null) {
                            SVNFileUtil.setExecutable(wcAccess.getAnchor().getFile(entry.getName()), true);
                        }
                        wcAccess.getAnchor().getEntries().save(true);
                        wcAccess.getAnchor().getEntries().close();
                        SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(wcAccess, wcAccess.getTargetName(), SVNEventAction.LOCKED, lock, null), -1.0);
                    }
                    finally {
                        wcAccess.close(true);
                    }
                } else {
                    SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(wcAccess, wcAccess.getTargetName(), SVNEventAction.LOCK_FAILED, lock, error), -1.0);
                }
            }

            public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) {
            }
        });
    }

    public void doLock(SVNURL[] urls, boolean stealLock, String lockMessage) throws SVNException {
        HashSet<String> paths = new HashSet<String>();
        SVNURL topURL = SVNURLUtil.condenceURLs(urls, paths, false);
        if (paths.isEmpty()) {
            paths.add("");
        }
        HashMap<String, Object> pathsToRevisions = new HashMap<String, Object>();
        Iterator p = paths.iterator();
        while (p.hasNext()) {
            String path = (String)p.next();
            path = SVNEncodingUtil.uriDecode(path);
            pathsToRevisions.put(path, null);
        }
        this.checkCancelled();
        SVNRepository repository = this.createRepository(topURL, true);
        repository.lock(pathsToRevisions, lockMessage, stealLock, new ISVNLockHandler(){

            public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                if (error != null) {
                    SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(path, SVNEventAction.LOCK_FAILED, lock, error), -1.0);
                } else {
                    SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(path, SVNEventAction.LOCKED, lock, null), -1.0);
                }
            }

            public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnlock(File[] paths, boolean breakLock) throws SVNException {
        SVNErrorMessage err;
        final HashMap<SVNURL, LockInfo> entriesMap = new HashMap<SVNURL, LockInfo>();
        for (int i = 0; i < paths.length; ++i) {
            SVNWCAccess wcAccess = this.createWCAccess(paths[i]);
            try {
                wcAccess.open(true, false);
                SVNEntry entry = wcAccess.getTargetEntry();
                if (entry == null) {
                    err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", paths[i]);
                    SVNErrorManager.error(err);
                }
                if (entry.getURL() == null) {
                    err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", paths[i]);
                    SVNErrorManager.error(err);
                }
                String lockToken = entry.getLockToken();
                if (!breakLock && lockToken == null) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_MISSING_LOCK_TOKEN, "''{0}'' is not locked", paths[i]);
                    SVNErrorManager.error(err2);
                }
                entriesMap.put(entry.getSVNURL(), new LockInfo(paths[i], lockToken));
                wcAccess.getAnchor().getEntries().close();
                continue;
            }
            finally {
                wcAccess.close(true);
            }
        }
        SVNURL[] urls = entriesMap.keySet().toArray(new SVNURL[entriesMap.size()]);
        HashSet<String> urlPaths = new HashSet<String>();
        SVNURL topURL = SVNURLUtil.condenceURLs(urls, urlPaths, false);
        if (urlPaths.isEmpty()) {
            urlPaths.add("");
        }
        if (topURL == null) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Paths belong to different repositories");
            SVNErrorManager.error(err);
        }
        HashMap<String, String> pathsTokensMap = new HashMap<String, String>();
        Iterator encodedPaths = urlPaths.iterator();
        while (encodedPaths.hasNext()) {
            String encodedPath = (String)encodedPaths.next();
            SVNURL fullURL = topURL.appendPath(encodedPath, true);
            LockInfo lockInfo = (LockInfo)entriesMap.get(fullURL);
            encodedPath = SVNEncodingUtil.uriDecode(encodedPath);
            pathsTokensMap.put(encodedPath, lockInfo.myToken);
        }
        this.checkCancelled();
        SVNRepository repository = this.createRepository(topURL, true);
        final SVNURL rootURL = repository.getRepositoryRoot(true);
        repository.unlock(pathsTokensMap, breakLock, new ISVNLockHandler(){

            public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                SVNURL fullURL = rootURL.appendPath(path, false);
                LockInfo lockInfo = (LockInfo)entriesMap.get(fullURL);
                SVNWCAccess wcAccess = SVNWCClient.this.createWCAccess(lockInfo.myFile);
                if (error != null) {
                    SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(wcAccess, wcAccess.getTargetName(), SVNEventAction.UNLOCK_FAILED, null, error), -1.0);
                }
                if (lock != null) {
                    try {
                        wcAccess.open(true, false);
                        SVNEntry entry = wcAccess.getAnchor().getEntries().getEntry(wcAccess.getTargetName(), true);
                        entry.setLockToken(null);
                        entry.setLockComment(null);
                        entry.setLockOwner(null);
                        entry.setLockCreationDate(null);
                        wcAccess.getAnchor().getEntries().save(true);
                        wcAccess.getAnchor().getEntries().close();
                        if (wcAccess.getAnchor().getProperties(entry.getName(), false).getPropertyValue("svn:needs-lock") != null) {
                            SVNFileUtil.setReadonly(wcAccess.getAnchor().getFile(entry.getName()), true);
                        }
                        SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(wcAccess, wcAccess.getTargetName(), SVNEventAction.UNLOCKED, lock, null), -1.0);
                    }
                    finally {
                        wcAccess.close(true);
                    }
                }
            }
        });
    }

    public void doUnlock(SVNURL[] urls, boolean breakLock) throws SVNException {
        HashSet<String> paths = new HashSet<String>();
        SVNURL topURL = SVNURLUtil.condenceURLs(urls, paths, false);
        if (paths.isEmpty()) {
            paths.add("");
        }
        Map<String, Object> pathsToTokens = new HashMap<String, Object>();
        Iterator p = paths.iterator();
        while (p.hasNext()) {
            String path = (String)p.next();
            path = SVNEncodingUtil.uriDecode(path);
            pathsToTokens.put(path, null);
        }
        this.checkCancelled();
        SVNRepository repository = this.createRepository(topURL, true);
        if (!breakLock) {
            pathsToTokens = this.fetchLockTokens(repository, pathsToTokens);
        }
        repository.unlock(pathsToTokens, breakLock, new ISVNLockHandler(){

            public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
            }

            public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                if (error != null) {
                    SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(path, SVNEventAction.UNLOCK_FAILED, null, error), -1.0);
                } else {
                    SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(path, SVNEventAction.UNLOCKED, null, null), -1.0);
                }
            }
        });
    }

    public void doInfo(File path, SVNRevision revision, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        this.doInfo(path, SVNRevision.UNDEFINED, revision, recursive, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInfo(File path, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        boolean local;
        if (handler == null) {
            return;
        }
        boolean bl = local = !(revision != null && revision.isValid() && !revision.isLocal() || pegRevision != null && pegRevision.isValid() && !pegRevision.isLocal());
        if (!local) {
            SVNWCAccess wcAccess = this.createWCAccess(path);
            SVNRevision wcRevision = null;
            SVNURL url = null;
            try {
                SVNErrorMessage err;
                wcAccess.open(false, false);
                SVNEntry entry = wcAccess.getTargetEntry();
                if (entry == null) {
                    err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", path);
                    SVNErrorManager.error(err);
                }
                if ((url = entry.getSVNURL()) == null) {
                    err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", path);
                    SVNErrorManager.error(err);
                }
                wcRevision = SVNRevision.create(entry.getRevision());
            }
            finally {
                wcAccess.close(false);
            }
            this.doInfo(url, pegRevision == null || !pegRevision.isValid() || pegRevision.isLocal() ? wcRevision : pegRevision, revision, recursive, handler);
            return;
        }
        SVNWCAccess wcAccess = this.createWCAccess(path);
        try {
            wcAccess.open(false, recursive);
            SVNWCClient.collectInfo(wcAccess.getAnchor(), wcAccess.getTargetName(), recursive, handler);
        }
        finally {
            wcAccess.close(false);
        }
    }

    public void doInfo(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        String fullPath;
        String rootPath;
        HashMap<String, SVNLock> locksMap;
        String reposUUID;
        SVNURL reposRoot;
        SVNDirEntry rootEntry;
        long revNum;
        SVNRepository repos;
        block22: {
            if (revision == null || !revision.isValid()) {
                revision = SVNRevision.HEAD;
            }
            if (pegRevision == null || !pegRevision.isValid()) {
                pegRevision = revision;
            }
            repos = this.createRepository(url, null, pegRevision, revision);
            url = repos.getLocation();
            revNum = this.getRevisionNumber(revision, repos, null);
            rootEntry = null;
            try {
                rootEntry = repos.info("", revNum);
            }
            catch (SVNException e) {
                if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                    if (repos.getLocation().equals(repos.getRepositoryRoot(true))) {
                        rootEntry = new SVNDirEntry(url, "", SVNNodeKind.DIR, -1L, false, -1L, null, null);
                    } else {
                        String name = SVNPathUtil.tail(url.getPath());
                        SVNURL location = repos.getLocation();
                        repos.setLocation(location.removePathTail(), false);
                        Collection dirEntries = repos.getDir("", revNum, null, (Collection)null);
                        Iterator ents = dirEntries.iterator();
                        while (ents.hasNext()) {
                            SVNDirEntry dirEntry = (SVNDirEntry)ents.next();
                            if (!name.equals(dirEntry.getName())) continue;
                            rootEntry = dirEntry;
                            break;
                        }
                        repos.setLocation(location, false);
                    }
                }
                throw e;
            }
            if (rootEntry == null || rootEntry.getKind() == SVNNodeKind.NONE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' non-existent in revision ''{1}''", new Object[]{url, new Long(revNum)});
                SVNErrorManager.error(err);
            }
            reposRoot = repos.getRepositoryRoot(true);
            reposUUID = repos.getRepositoryUUID(true);
            SVNLock[] locks = null;
            if (pegRevision == SVNRevision.HEAD && rootEntry.getKind() == SVNNodeKind.DIR) {
                try {
                    locks = repos.getLocks("");
                }
                catch (SVNException e) {
                    if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                        locks = new SVNLock[]{};
                    }
                    throw e;
                }
            }
            locks = locks == null ? new SVNLock[]{} : locks;
            locksMap = new HashMap<String, SVNLock>();
            for (int i = 0; i < locks.length; ++i) {
                SVNLock lock = locks[i];
                locksMap.put(lock.getPath(), lock);
            }
            if (rootEntry.getKind() == SVNNodeKind.FILE) {
                try {
                    SVNURL headURL;
                    SVNBasicClient.SVNRepositoryLocation[] locations = this.getLocations(url, null, revision, SVNRevision.HEAD, SVNRevision.UNDEFINED);
                    if (locations == null || locations.length <= 0 || !(headURL = locations[0].getURL()).equals(url)) break block22;
                    try {
                        SVNLock lock = repos.getLock("");
                        if (lock != null) {
                            locksMap.put(lock.getPath(), lock);
                        }
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage() == null || e.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) {
                            throw e;
                        }
                    }
                }
                catch (SVNException e) {
                    SVNErrorCode code = e.getErrorMessage().getErrorCode();
                    if (code == SVNErrorCode.FS_NOT_FOUND || code == SVNErrorCode.CLIENT_UNRELATED_RESOURCES) break block22;
                    throw e;
                }
            }
        }
        if (!(rootPath = (fullPath = url.getPath()).substring(reposRoot.getPath().length())).startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        this.collectInfo(repos, rootEntry, SVNRevision.create(revNum), rootPath, reposRoot, reposUUID, url, locksMap, recursive, handler);
    }

    public String doGetWorkingCopyID(final File path, String trailURL) throws SVNException {
        try {
            this.createWCAccess(path);
        }
        catch (SVNException e) {
            SVNFileType pathType = SVNFileType.getType(path);
            if (pathType == SVNFileType.DIRECTORY) {
                return "exported";
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' is not versioned and not exported", path);
            SVNErrorManager.error(err);
        }
        SVNStatusClient statusClient = new SVNStatusClient((ISVNAuthenticationManager)null, this.getOptions());
        statusClient.setIgnoreExternals(true);
        final long[] maxRevision = new long[1];
        final long[] minRevision = new long[]{-1L};
        final boolean[] switched = new boolean[2];
        final String[] wcURL = new String[1];
        statusClient.doStatus(path, true, false, true, false, false, new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) {
                SVNRevision revision;
                if (status.getEntryProperties() == null || status.getEntryProperties().isEmpty()) {
                    return;
                }
                if (status.getContentsStatus() != SVNStatusType.STATUS_ADDED && (revision = status.getRevision()) != null) {
                    if (minRevision[0] < 0L || minRevision[0] > revision.getNumber()) {
                        minRevision[0] = revision.getNumber();
                    }
                    maxRevision[0] = Math.max(maxRevision[0], revision.getNumber());
                }
                switched[0] = switched[0] | status.isSwitched();
                switched[1] = switched[1] | status.getContentsStatus() != SVNStatusType.STATUS_NORMAL;
                switched[1] = switched[1] | (status.getPropertiesStatus() != SVNStatusType.STATUS_NORMAL && status.getPropertiesStatus() != SVNStatusType.STATUS_NONE);
                if (wcURL[0] == null && status.getFile() != null && status.getFile().equals(path) && status.getURL() != null) {
                    wcURL[0] = status.getURL().toString();
                }
            }
        });
        if (!switched[0] && trailURL != null) {
            switched[0] = wcURL[0] == null ? true : !wcURL[0].endsWith(trailURL);
        }
        StringBuffer id = new StringBuffer();
        id.append(minRevision[0]);
        if (minRevision[0] != maxRevision[0]) {
            id.append(":").append(maxRevision[0]);
        }
        if (switched[1]) {
            id.append("M");
        }
        if (switched[0]) {
            id.append("S");
        }
        return id.toString();
    }

    public SVNInfo doInfo(File path, SVNRevision revision) throws SVNException {
        final SVNInfo[] result = new SVNInfo[1];
        this.doInfo(path, revision, false, new ISVNInfoHandler(){

            public void handleInfo(SVNInfo info) {
                if (result[0] == null) {
                    result[0] = info;
                }
            }
        });
        return result[0];
    }

    public SVNInfo doInfo(SVNURL url, SVNRevision pegRevision, SVNRevision revision) throws SVNException {
        final SVNInfo[] result = new SVNInfo[1];
        this.doInfo(url, pegRevision, revision, false, new ISVNInfoHandler(){

            public void handleInfo(SVNInfo info) {
                if (result[0] == null) {
                    result[0] = info;
                }
            }
        });
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectInfo(SVNDirectory dir, String name, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        SVNEntries entries = dir.getEntries();
        SVNEntry entry = entries.getEntry(name, false);
        dir.getWCAccess().checkCancelled();
        try {
            if (entry != null) {
                if (entry.isFile()) {
                    File file = dir.getFile(name);
                    handler.handleInfo(SVNInfo.createInfo(file, entry));
                    return;
                }
                if (entry.isDirectory() && !"".equals(name)) {
                    if ((dir = dir.getChildDirectory(name)) != null) {
                        SVNWCClient.collectInfo(dir, "", recursive, handler);
                    }
                    return;
                }
                if ("".equals(name)) {
                    handler.handleInfo(SVNInfo.createInfo(dir.getRoot(), entry));
                }
                if (recursive) {
                    Iterator ents = entries.entries(true);
                    while (ents.hasNext()) {
                        SVNEntry childEntry = (SVNEntry)ents.next();
                        if ("".equals(childEntry.getName())) continue;
                        if (childEntry.isDirectory()) {
                            SVNDirectory childDir = dir.getChildDirectory(childEntry.getName());
                            if (childDir == null) continue;
                            SVNWCClient.collectInfo(childDir, "", recursive, handler);
                            continue;
                        }
                        if (!childEntry.isFile()) continue;
                        handler.handleInfo(SVNInfo.createInfo(dir.getFile(childEntry.getName()), childEntry));
                    }
                }
            }
        }
        finally {
            entries.close();
        }
    }

    private void collectInfo(SVNRepository repos, SVNDirEntry entry, SVNRevision rev, String path, SVNURL root, String uuid, SVNURL url, Map locks, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        this.checkCancelled();
        String displayPath = repos.getFullPath(path);
        displayPath = displayPath.substring(repos.getLocation().getPath().length());
        if ("".equals(displayPath) || "/".equals(displayPath)) {
            displayPath = path;
        }
        handler.handleInfo(SVNInfo.createInfo(displayPath, root, uuid, url, rev, entry, (SVNLock)locks.get(path)));
        if (entry.getKind() == SVNNodeKind.DIR && recursive) {
            Collection children = repos.getDir(path, rev.getNumber(), null, new ArrayList());
            Iterator ents = children.iterator();
            while (ents.hasNext()) {
                SVNDirEntry child = (SVNDirEntry)ents.next();
                SVNURL childURL = url.appendPath(child.getName(), false);
                this.collectInfo(repos, child, rev, SVNPathUtil.append(path, child.getName()), root, uuid, childURL, locks, recursive, handler);
            }
        }
    }

    private void addDirectory(SVNWCAccess wcAccess, SVNDirectory dir, String name, boolean force) throws SVNException {
        if (dir.add(name, false, force) == null) {
            return;
        }
        File file = dir.getFile(name);
        SVNDirectory childDir = dir.getChildDirectory(name);
        if (childDir == null) {
            return;
        }
        File[] children = file.listFiles();
        for (int i = 0; children != null && i < children.length; ++i) {
            File childFile = children[i];
            if (this.getOptions().isIgnored(childFile.getName()) || childDir.isIgnored(childFile.getName()) || SVNFileUtil.getAdminDirectoryName().equals(childFile.getName())) continue;
            SVNFileType fileType = SVNFileType.getType(childFile);
            if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
                SVNEntry entry = childDir.getEntries().getEntry(childFile.getName(), true);
                if (force && entry != null && !entry.isScheduledForDeletion() && !entry.isDeleted()) continue;
                this.addSingleFile(childDir, childFile.getName());
                continue;
            }
            if (SVNFileType.DIRECTORY != fileType) continue;
            this.addDirectory(wcAccess, childDir, childFile.getName(), force);
        }
    }

    private void addSingleFile(SVNDirectory dir, String name) throws SVNException {
        File file = dir.getFile(name);
        dir.add(name, false, false);
        SVNProperties properties = dir.getProperties(name, false);
        if (SVNFileType.getType(file) == SVNFileType.SYMLINK) {
            properties.setPropertyValue("svn:special", "*");
        } else {
            boolean executable;
            Map<String, String> props = new HashMap();
            props = this.getOptions().applyAutoProperties(name, props);
            String mimeType = (String)props.get("svn:mime-type");
            if (mimeType == null && (mimeType = SVNFileUtil.detectMimeType(file)) != null) {
                props.put("svn:mime-type", mimeType);
                props.remove("svn:eol-style");
            }
            if (!props.containsKey("svn:executable") && (executable = SVNFileUtil.isExecutable(file))) {
                props.put("svn:executable", "*");
            }
            if (props.get("svn:mime-type") != null && props.get("svn:eol-style") != null) {
                props.remove("svn:eol-style");
            }
            Iterator names = props.keySet().iterator();
            while (names.hasNext()) {
                String propName = (String)names.next();
                String propValue = (String)props.get(propName);
                try {
                    this.doSetLocalProperty(dir, name, propName, propValue, false, false, false, null);
                }
                catch (SVNException e) {}
            }
        }
    }

    private void doGetRemoteProperty(SVNURL url, String path, SVNRepository repos, String propName, SVNRevision rev, boolean recursive, ISVNPropertyHandler handler) throws SVNException {
        block7: {
            HashMap props;
            block8: {
                SVNNodeKind kind;
                long revNumber;
                block6: {
                    this.checkCancelled();
                    revNumber = this.getRevisionNumber(rev, repos, null);
                    kind = repos.checkPath(path, revNumber);
                    props = new HashMap();
                    if (kind != SVNNodeKind.DIR) break block6;
                    Collection children = repos.getDir(path, revNumber, props, (Collection)(recursive ? new ArrayList() : null));
                    if (propName != null) {
                        String value = (String)props.get(propName);
                        if (value != null) {
                            handler.handleProperty(url, new SVNPropertyData(propName, value));
                        }
                    } else {
                        Iterator names = props.keySet().iterator();
                        while (names.hasNext()) {
                            String name = (String)names.next();
                            if (name.startsWith("svn:entry:") || name.startsWith("svn:wc:")) continue;
                            String value = (String)props.get(name);
                            handler.handleProperty(url, new SVNPropertyData(name, value));
                        }
                    }
                    if (!recursive) break block7;
                    this.checkCancelled();
                    Iterator entries = children.iterator();
                    while (entries.hasNext()) {
                        SVNDirEntry child = (SVNDirEntry)entries.next();
                        SVNURL childURL = url.appendPath(child.getName(), false);
                        String childPath = "".equals(path) ? child.getName() : SVNPathUtil.append(path, child.getName());
                        this.doGetRemoteProperty(childURL, childPath, repos, propName, rev, recursive, handler);
                    }
                    break block7;
                }
                if (kind != SVNNodeKind.FILE) break block7;
                repos.getFile(path, revNumber, props, null);
                if (propName == null) break block8;
                String value = (String)props.get(propName);
                if (value == null) break block7;
                handler.handleProperty(url, new SVNPropertyData(propName, value));
                break block7;
            }
            Iterator names = props.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                if (name.startsWith("svn:entry:") || name.startsWith("svn:wc:")) continue;
                String value = (String)props.get(name);
                handler.handleProperty(url, new SVNPropertyData(name, value));
            }
        }
    }

    private void doGetLocalProperty(SVNDirectory anchor, String name, String propName, SVNRevision rev, boolean recursive, ISVNPropertyHandler handler) throws SVNException {
        SVNProperties props;
        this.checkCancelled();
        SVNEntries entries = anchor.getEntries();
        SVNEntry entry = entries.getEntry(name, true);
        if (entry == null || rev == SVNRevision.WORKING && entry.isScheduledForDeletion()) {
            return;
        }
        if (!"".equals(name)) {
            if (entry.getKind() == SVNNodeKind.DIR) {
                SVNDirectory dir = anchor.getChildDirectory(name);
                if (dir != null) {
                    this.doGetLocalProperty(dir, "", propName, rev, recursive, handler);
                }
            } else if (entry.getKind() == SVNNodeKind.FILE) {
                SVNProperties props2;
                SVNProperties sVNProperties = props2 = rev == SVNRevision.WORKING ? anchor.getProperties(name, false) : anchor.getBaseProperties(name, false);
                if (propName != null) {
                    String value = props2.getPropertyValue(propName);
                    if (value != null) {
                        handler.handleProperty(anchor.getFile(name), new SVNPropertyData(propName, value));
                    }
                } else {
                    Map propsMap = props2.asMap();
                    Iterator names = propsMap.keySet().iterator();
                    while (names.hasNext()) {
                        String pName = (String)names.next();
                        String value = (String)propsMap.get(pName);
                        handler.handleProperty(anchor.getFile(name), new SVNPropertyData(pName, value));
                    }
                }
            }
            entries.close();
            return;
        }
        SVNProperties sVNProperties = props = rev == SVNRevision.WORKING ? anchor.getProperties(name, false) : anchor.getBaseProperties(name, false);
        if (propName != null) {
            String value = props.getPropertyValue(propName);
            if (value != null) {
                handler.handleProperty(anchor.getFile(name), new SVNPropertyData(propName, value));
            }
        } else {
            Map propsMap = props.asMap();
            Iterator names = propsMap.keySet().iterator();
            while (names.hasNext()) {
                String pName = (String)names.next();
                String value = (String)propsMap.get(pName);
                handler.handleProperty(anchor.getFile(name), new SVNPropertyData(pName, value));
            }
        }
        if (!recursive) {
            return;
        }
        Iterator ents = entries.entries(true);
        while (ents.hasNext()) {
            SVNEntry childEntry = (SVNEntry)ents.next();
            if ("".equals(childEntry.getName())) continue;
            this.doGetLocalProperty(anchor, childEntry.getName(), propName, rev, recursive, handler);
        }
    }

    private void doSetLocalProperty(SVNDirectory anchor, String name, String propName, String propValue, boolean force, boolean recursive, boolean cancel, ISVNPropertyHandler handler) throws SVNException {
        if (cancel) {
            this.checkCancelled();
        }
        SVNEntries entries = anchor.getEntries();
        if (!"".equals(name)) {
            SVNEntry entry = entries.getEntry(name, true);
            if (entry == null || recursive && entry.isDeleted()) {
                return;
            }
            if (entry.getKind() == SVNNodeKind.DIR) {
                SVNDirectory dir = anchor.getChildDirectory(name);
                if (dir != null) {
                    this.doSetLocalProperty(dir, "", propName, propValue, force, recursive, cancel, handler);
                }
            } else if (entry.getKind() == SVNNodeKind.FILE) {
                File wcFile = anchor.getFile(name);
                if ("svn:ignore".equals(propName) || "svn:externals".equals(propName)) {
                    if (!recursive) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot set ''{0}'' on a file (''{1}'')", new Object[]{propName, wcFile});
                        SVNErrorManager.error(err);
                    }
                    return;
                }
                SVNProperties props = anchor.getProperties(name, false);
                if ("svn:executable".equals(propName)) {
                    SVNFileUtil.setExecutable(wcFile, propValue != null);
                }
                if (!force && "svn:eol-style".equals(propName) && propValue != null) {
                    if (SVNProperty.isBinaryMimeType(props.getPropertyValue("svn:mime-type"))) {
                        if (!recursive) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "File ''{0}'' has binary mime type property", wcFile);
                            SVNErrorManager.error(err);
                        }
                        return;
                    }
                    if (!SVNTranslator.checkNewLines(wcFile)) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "File ''{0}'' has incosistent newlines", wcFile);
                        SVNErrorManager.error(err);
                    }
                }
                props.setPropertyValue(propName, propValue);
                if ("svn:eol-style".equals(propName) || "svn:keywords".equals(propName)) {
                    entry.setTextTime(null);
                    entries.save(false);
                } else if ("svn:needs-lock".equals(propName) && propValue == null) {
                    SVNFileUtil.setReadonly(wcFile, false);
                }
                if (handler != null) {
                    handler.handleProperty(anchor.getFile(name), new SVNPropertyData(propName, propValue));
                }
            }
            entries.close();
            return;
        }
        SVNProperties props = anchor.getProperties(name, false);
        if ("svn:keywords".equals(propName) || "svn:eol-style".equals(propName) || "svn:mime-type".equals(propName) || "svn:executable".equals(propName)) {
            if (!recursive) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot set ''{0}'' on a directory (''{1}'')", new Object[]{propName, anchor.getRoot()});
                SVNErrorManager.error(err);
            }
        } else {
            props.setPropertyValue(propName, propValue);
            if (handler != null) {
                handler.handleProperty(anchor.getFile(name), new SVNPropertyData(propName, propValue));
            }
        }
        if (!recursive) {
            return;
        }
        Iterator ents = entries.entries(true);
        while (ents.hasNext()) {
            SVNEntry entry = (SVNEntry)ents.next();
            if ("".equals(entry.getName())) continue;
            this.doSetLocalProperty(anchor, entry.getName(), propName, propValue, force, recursive, cancel, handler);
        }
    }

    private static String validatePropertyName(String name) throws SVNException {
        if (name == null || name.trim().length() == 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property name is empty");
            SVNErrorManager.error(err);
            return name;
        }
        if (!Character.isLetter((name = name.trim()).charAt(0)) && name.charAt(0) != ':' && name.charAt(0) != '_') {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name ''{0}''", name);
            SVNErrorManager.error(err);
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isLetterOrDigit(name.charAt(i)) || name.charAt(i) == '-' || name.charAt(i) == '.' || name.charAt(i) == ':' || name.charAt(i) == '_') continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name ''{0}''", name);
            SVNErrorManager.error(err);
        }
        return name;
    }

    private static String validatePropertyValue(String name, String value, boolean force) throws SVNException {
        if (value == null) {
            return value;
        }
        if (SVNProperty.isSVNProperty(name)) {
            value = SVNTranslator.convertEOLs(value);
        }
        if (!force && "svn:eol-style".equals(name)) {
            value = value.trim();
        } else if (!force && "svn:mime-type".equals(name)) {
            value = value.trim();
        } else if ("svn:ignore".equals(name) || "svn:externals".equals(name)) {
            if (!value.endsWith("\n")) {
                value = value + "\n";
            }
            if ("svn:externals".equals(name)) {
                SVNExternalInfo[] externalInfos = SVNWCAccess.parseExternals("", value);
                for (int i = 0; externalInfos != null && i < externalInfos.length; ++i) {
                    String path = externalInfos[i].getPath();
                    SVNExternalInfo.checkPath(path);
                }
            }
        } else if ("svn:keywords".equals(name)) {
            value = value.trim();
        } else if ("svn:executable".equals(name) || "svn:special".equals(name) || "svn:needs-lock".equals(name)) {
            value = "*";
        }
        return value;
    }

    private Map fetchLockTokens(SVNRepository repository, Map pathsTokensMap) throws SVNException {
        HashMap<String, String> tokens = new HashMap<String, String>();
        Iterator paths = pathsTokensMap.keySet().iterator();
        while (paths.hasNext()) {
            String path = (String)paths.next();
            SVNLock lock = repository.getLock(path);
            if (lock == null || lock.getID() == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MISSING_LOCK_TOKEN, "''{0}'' is not locked", path);
                SVNErrorManager.error(err);
                continue;
            }
            tokens.put(path, lock.getID());
        }
        return tokens;
    }

    private static class LockInfo {
        private File myFile;
        private SVNRevision myRevision;
        private String myToken;

        public LockInfo(File file, SVNRevision rev) {
            this.myFile = file;
            this.myRevision = rev;
        }

        public LockInfo(File file, String token) {
            this.myFile = file;
            this.myToken = token;
        }
    }
}

